/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.client;

import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Map;

public class StringUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String EMPTY_STRING = "";

    public static boolean isEmpty(String text) {
        if (text == null) {
            return true;
        }
        return EMPTY_STRING.equals(text.trim());
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static String removeLastPart(String string, char separator) {
        int idx = string.lastIndexOf(separator);
        if (idx == -1) {
            return string;
        }
        return string.substring(0, idx);
    }

    public static String stripPrefix(String string, String prefix) {
        if (string.startsWith(prefix)) {
            return string.substring(prefix.length());
        }
        return string;
    }

    public static String stripSuffix(String string, String suffix) {
        if (string.endsWith(suffix)) {
            return string.substring(0, string.length() - suffix.length());
        }
        return string;
    }

    public static String toString(Map<?, ?> map) {
        return StringUtils.toString(map, EMPTY_STRING);
    }

    public static String toString(Map<?, ?> map, String indent) {
        StringBuilder result = new StringBuilder();
        Iterator<?> keyIterator = map.keySet().iterator();
        while (keyIterator.hasNext()) {
            result.append(indent);
            Object key = keyIterator.next();
            result.append(key);
            result.append(" = ");
            result.append(map.get(key));
            if (!keyIterator.hasNext()) continue;
            result.append(LINE_SEPARATOR);
        }
        return result.toString();
    }

    public static String format(double number, NumberFormat numberFormat) {
        if (numberFormat == null) {
            return String.valueOf(number);
        }
        return numberFormat.format(number);
    }

    public static int editDistance(String s, String t) {
        char[] sChars = s.toCharArray();
        char[] tChars = t.toCharArray();
        int m = s.length();
        int n = t.length();
        int[] distance = new int[m + 1];
        for (int i = 0; i <= m; ++i) {
            distance[i] = i;
        }
        int[] oldDistance = new int[m + 1];
        for (int j = 1; j <= n; ++j) {
            int[] tmp = oldDistance;
            oldDistance = distance;
            distance = tmp;
            distance[0] = j;
            for (int i = 1; i <= m; ++i) {
                int cost = 1 + Math.min(distance[i - 1], oldDistance[i]);
                cost = sChars[i - 1] == tChars[j - 1] ? Math.min(cost, oldDistance[i - 1]) : Math.min(cost, 1 + oldDistance[i - 1]);
                distance[i] = cost;
            }
        }
        return distance[m];
    }
}

