/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.client;

import com.teamscale.client.ClusteredTestDetails;
import com.teamscale.client.CommitDescriptor;
import com.teamscale.client.EReportFormat;
import com.teamscale.client.ETestImpactOptions;
import com.teamscale.client.HttpUtils;
import com.teamscale.client.ITeamscaleService;
import com.teamscale.client.PrioritizableTest;
import com.teamscale.client.PrioritizableTestCluster;
import com.teamscale.client.TeamscaleServiceGenerator;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class TeamscaleClient {
    public final ITeamscaleService service;
    private final String projectId;

    public TeamscaleClient(String baseUrl, String user, String accessToken, String projectId) {
        this.projectId = projectId;
        this.service = TeamscaleServiceGenerator.createService(ITeamscaleService.class, HttpUrl.parse((String)baseUrl), user, accessToken, new Interceptor[0]);
    }

    public TeamscaleClient(String baseUrl, String user, String accessToken, String projectId, File file) {
        this.projectId = projectId;
        this.service = TeamscaleServiceGenerator.createServiceWithRequestLogging(ITeamscaleService.class, HttpUrl.parse((String)baseUrl), user, accessToken, file, new Interceptor[0]);
    }

    public retrofit2.Response<List<PrioritizableTestCluster>> getImpactedTests(List<ClusteredTestDetails> availableTests, String baseline, CommitDescriptor endCommit, List<String> partitions, boolean includeNonImpacted) throws IOException {
        if (includeNonImpacted) {
            return this.getImpactedTests(availableTests, baseline, endCommit, partitions, ETestImpactOptions.INCLUDE_NON_IMPACTED, ETestImpactOptions.ENSURE_PROCESSED, ETestImpactOptions.INCLUDE_FAILED_AND_SKIPPED);
        }
        return this.getImpactedTests(availableTests, baseline, endCommit, partitions, ETestImpactOptions.ENSURE_PROCESSED, ETestImpactOptions.INCLUDE_FAILED_AND_SKIPPED);
    }

    public retrofit2.Response<List<PrioritizableTestCluster>> getImpactedTests(List<ClusteredTestDetails> availableTests, String baseline, CommitDescriptor endCommit, List<String> partitions, ETestImpactOptions ... options) throws IOException {
        EnumSet<ETestImpactOptions> testImpactOptions = EnumSet.copyOf(Arrays.asList(options));
        boolean includeNonImpacted = testImpactOptions.contains((Object)ETestImpactOptions.INCLUDE_NON_IMPACTED);
        boolean includeFailedAndSkippedTests = testImpactOptions.contains((Object)ETestImpactOptions.INCLUDE_FAILED_AND_SKIPPED);
        boolean ensureProcessed = testImpactOptions.contains((Object)ETestImpactOptions.ENSURE_PROCESSED);
        if (availableTests == null) {
            return TeamscaleClient.wrapInCluster((retrofit2.Response<List<PrioritizableTest>>)this.service.getImpactedTests(this.projectId, baseline, endCommit, partitions, includeNonImpacted, includeFailedAndSkippedTests, ensureProcessed).execute());
        }
        return this.service.getImpactedTests(this.projectId, baseline, endCommit, partitions, includeNonImpacted, includeFailedAndSkippedTests, ensureProcessed, availableTests).execute();
    }

    private static retrofit2.Response<List<PrioritizableTestCluster>> wrapInCluster(retrofit2.Response<List<PrioritizableTest>> testListResponse) {
        if (testListResponse.isSuccessful()) {
            return retrofit2.Response.success(Collections.singletonList(new PrioritizableTestCluster("dummy", (List)testListResponse.body())), (Response)testListResponse.raw());
        }
        return retrofit2.Response.error((ResponseBody)testListResponse.errorBody(), (Response)testListResponse.raw());
    }

    public void uploadReports(EReportFormat reportFormat, Collection<File> reports, CommitDescriptor commitDescriptor, String revision, String partition, String message) throws IOException {
        List<MultipartBody.Part> partList = reports.stream().map(file -> {
            RequestBody requestBody = RequestBody.create((MediaType)MultipartBody.FORM, (File)file);
            return MultipartBody.Part.createFormData((String)"report", (String)file.getName(), (RequestBody)requestBody);
        }).collect(Collectors.toList());
        retrofit2.Response response = this.service.uploadExternalReports(this.projectId, reportFormat, commitDescriptor, revision, true, partition, message, partList).execute();
        if (!response.isSuccessful()) {
            throw new IOException("HTTP request failed: " + HttpUtils.getErrorBodyStringSafe(response));
        }
    }

    public void uploadReport(EReportFormat reportFormat, String report, CommitDescriptor commitDescriptor, String revision, String partition, String message) throws IOException {
        RequestBody requestBody = RequestBody.create((MediaType)MultipartBody.FORM, (String)report);
        this.service.uploadReport(this.projectId, commitDescriptor, revision, partition, reportFormat, message, requestBody);
    }
}

