/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.client;

import com.teamscale.client.FileLoggingInterceptor;
import com.teamscale.client.HttpUtils;
import java.io.File;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

public class TeamscaleServiceGenerator {
    public static final String USER_AGENT = "Teamscale JaCoCo Agent";

    public static <S> S createService(Class<S> serviceClass, HttpUrl baseUrl, String username, String accessToken, int readTimeout, int writeTimeout, Interceptor ... interceptors) {
        Retrofit retrofit = HttpUtils.createRetrofit(retrofitBuilder -> retrofitBuilder.baseUrl(baseUrl).addConverterFactory((Converter.Factory)MoshiConverterFactory.create()), okHttpBuilder -> TeamscaleServiceGenerator.addInterceptors(okHttpBuilder, interceptors).addInterceptor(HttpUtils.getBasicAuthInterceptor(username, accessToken)).addInterceptor((Interceptor)new AcceptJsonInterceptor()).addNetworkInterceptor((Interceptor)new CustomUserAgentInterceptor()), readTimeout, writeTimeout);
        return (S)retrofit.create(serviceClass);
    }

    public static <S> S createServiceWithRequestLogging(Class<S> serviceClass, HttpUrl baseUrl, String username, String accessToken, File logfile, int readTimeout, int writeTimeout, Interceptor ... interceptors) {
        Retrofit retrofit = HttpUtils.createRetrofit(retrofitBuilder -> retrofitBuilder.baseUrl(baseUrl).addConverterFactory((Converter.Factory)MoshiConverterFactory.create()), okHttpBuilder -> TeamscaleServiceGenerator.addInterceptors(okHttpBuilder, interceptors).addInterceptor(HttpUtils.getBasicAuthInterceptor(username, accessToken)).addInterceptor((Interceptor)new AcceptJsonInterceptor()).addNetworkInterceptor((Interceptor)new CustomUserAgentInterceptor()).addInterceptor((Interceptor)new FileLoggingInterceptor(logfile)), readTimeout, writeTimeout);
        return (S)retrofit.create(serviceClass);
    }

    private static OkHttpClient.Builder addInterceptors(OkHttpClient.Builder builder, Interceptor ... interceptors) {
        for (Interceptor interceptor : interceptors) {
            builder.addInterceptor(interceptor);
        }
        return builder;
    }

    public static class CustomUserAgentInterceptor
    implements Interceptor {
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request newRequest = chain.request().newBuilder().header("User-Agent", TeamscaleServiceGenerator.USER_AGENT).build();
            return chain.proceed(newRequest);
        }
    }

    private static class AcceptJsonInterceptor
    implements Interceptor {
        private AcceptJsonInterceptor() {
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request newRequest = chain.request().newBuilder().header("Accept", "application/json").build();
            return chain.proceed(newRequest);
        }
    }
}

