/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale;

import com.teamscale.client.CommitDescriptor;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/teamscale/GitRepositoryHelper;", "", "()V", "getCommit", "Lorg/eclipse/jgit/revwalk/RevCommit;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "revisionBranchOrTag", "", "getHeadCommitDescriptor", "Lkotlin/Pair;", "Lcom/teamscale/client/CommitDescriptor;", "baseDirectory", "Ljava/io/File;", "teamscale-gradle-plugin"})
public final class GitRepositoryHelper {
    @NotNull
    public static final GitRepositoryHelper INSTANCE;

    @NotNull
    public final Pair<CommitDescriptor, String> getHeadCommitDescriptor(@NotNull File baseDirectory) throws IOException {
        String branch;
        Repository repository;
        Git git;
        Intrinsics.checkNotNullParameter((Object)baseDirectory, (String)"baseDirectory");
        Git git2 = git = Git.open((File)baseDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)git2, (String)"git");
        Repository repository2 = repository = git2.getRepository();
        Intrinsics.checkNotNullExpressionValue((Object)repository2, (String)"repository");
        String string = branch = repository2.getBranch();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"branch");
        RevCommit commit = this.getCommit(repository, string);
        long commitTimeSeconds = commit.getCommitTime();
        Ref ref = repository.getRefDatabase().findRef("HEAD");
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"repository.refDatabase.findRef(\"HEAD\")");
        ObjectId objectId = ref.getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId, (String)"repository.refDatabase.findRef(\"HEAD\").objectId");
        String ref2 = objectId.getName();
        return new Pair((Object)new CommitDescriptor(branch, commitTimeSeconds * 1000L), (Object)ref2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RevCommit getCommit(Repository repository, String revisionBranchOrTag) throws IOException {
        RevWalk revWalk = new RevWalk(repository);
        try {
            RevCommit revCommit;
            Ref head = repository.getRefDatabase().findRef(revisionBranchOrTag);
            if (head != null) {
                Ref ref = head.getLeaf();
                Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"head.leaf");
                RevCommit revCommit2 = revWalk.parseCommit((AnyObjectId)ref.getObjectId());
                revCommit = revCommit2;
                Intrinsics.checkNotNullExpressionValue((Object)revCommit2, (String)"revWalk.parseCommit(head.leaf.objectId)");
            } else {
                RevCommit revCommit3 = revWalk.parseCommit((AnyObjectId)ObjectId.fromString((String)revisionBranchOrTag));
                revCommit = revCommit3;
                Intrinsics.checkNotNullExpressionValue((Object)revCommit3, (String)"revWalk.parseCommit(Obje\u2026ing(revisionBranchOrTag))");
            }
            RevCommit revCommit4 = revCommit;
            return revCommit4;
        }
        finally {
            revWalk.close();
        }
    }

    private GitRepositoryHelper() {
    }

    static {
        GitRepositoryHelper gitRepositoryHelper;
        INSTANCE = gitRepositoryHelper = new GitRepositoryHelper();
    }
}

