/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale;

import com.teamscale.Report;
import com.teamscale.TeamscaleUploadTaskKt;
import com.teamscale.client.CommitDescriptor;
import com.teamscale.client.EReportFormat;
import com.teamscale.client.TeamscaleClient;
import com.teamscale.config.Commit;
import com.teamscale.config.ServerConfiguration;
import com.teamscale.config.extension.TeamscalePluginExtension;
import java.io.File;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020!H\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198G\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8G\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006#"}, d2={"Lcom/teamscale/TeamscaleUploadTask;", "Lorg/gradle/api/DefaultTask;", "()V", "commitDescriptor", "Lcom/teamscale/client/CommitDescriptor;", "getCommitDescriptor", "()Lcom/teamscale/client/CommitDescriptor;", "extension", "Lcom/teamscale/config/extension/TeamscalePluginExtension;", "getExtension", "()Lcom/teamscale/config/extension/TeamscalePluginExtension;", "setExtension", "(Lcom/teamscale/config/extension/TeamscalePluginExtension;)V", "ignoreFailures", "", "getIgnoreFailures", "()Z", "setIgnoreFailures", "(Z)V", "reports", "", "Lcom/teamscale/Report;", "getReports", "()Ljava/util/Set;", "revision", "", "getRevision", "()Ljava/lang/String;", "server", "Lcom/teamscale/config/ServerConfiguration;", "getServer", "()Lcom/teamscale/config/ServerConfiguration;", "action", "", "uploadReports", "teamscale-gradle-plugin"})
public class TeamscaleUploadTask
extends DefaultTask {
    @Internal
    public TeamscalePluginExtension extension;
    @Input
    @NotNull
    private final Set<Report> reports;
    @Input
    private boolean ignoreFailures;

    @NotNull
    public final TeamscalePluginExtension getExtension() {
        TeamscalePluginExtension teamscalePluginExtension = this.extension;
        if (teamscalePluginExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extension");
        }
        return teamscalePluginExtension;
    }

    public final void setExtension(@NotNull TeamscalePluginExtension teamscalePluginExtension) {
        Intrinsics.checkNotNullParameter((Object)teamscalePluginExtension, (String)"<set-?>");
        this.extension = teamscalePluginExtension;
    }

    @Input
    @NotNull
    public final ServerConfiguration getServer() {
        TeamscalePluginExtension teamscalePluginExtension = this.extension;
        if (teamscalePluginExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extension");
        }
        return teamscalePluginExtension.getServer();
    }

    @Input
    @Nullable
    public final CommitDescriptor getCommitDescriptor() {
        TeamscalePluginExtension teamscalePluginExtension = this.extension;
        if (teamscalePluginExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extension");
        }
        Commit commit = teamscalePluginExtension.getCommit();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return (CommitDescriptor)commit.getOrResolveCommitDescriptor(project).getFirst();
    }

    @Input
    @Nullable
    public final String getRevision() {
        TeamscalePluginExtension teamscalePluginExtension = this.extension;
        if (teamscalePluginExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extension");
        }
        Commit commit = teamscalePluginExtension.getCommit();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return (String)commit.getOrResolveCommitDescriptor(project).getSecond();
    }

    @NotNull
    public final Set<Report> getReports() {
        return this.reports;
    }

    public final boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public final void setIgnoreFailures(boolean bl) {
        this.ignoreFailures = bl;
    }

    @TaskAction
    public final void action() {
        if (this.reports.isEmpty()) {
            this.getLogger().info("Skipping upload. No reports to upload.");
            return;
        }
        this.getServer().validate();
        try {
            String string = this.getRevision();
            this.getLogger().info("Uploading to " + this.getServer() + " at " + (string != null ? (Serializable)((Object)string) : (Serializable)this.getCommitDescriptor()) + "...");
            this.uploadReports();
        }
        catch (Exception e) {
            if (this.ignoreFailures) {
                this.getLogger().warn("Ignoring failure during upload:");
                this.getLogger().warn(e.getMessage(), (Throwable)e);
            }
            throw (Throwable)e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void uploadReports() {
        Object answer$iv$iv$iv;
        EReportFormat $this$groupByTo$iv$iv;
        Object $this$groupBy$iv = this.reports;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv22 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Report it = (Report)element$iv$iv;
            boolean bl = false;
            Triple key$iv$iv = new Triple((Object)it.getFormat(), (Object)it.getPartition(), (Object)it.getMessage());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv22;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv22;
        $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void partition;
            void format;
            void $this$mapTo$iv$iv;
            void key;
            EReportFormat eReportFormat;
            $this$groupByTo$iv$iv = eReportFormat = iterator.next();
            boolean destination$iv$iv22 = false;
            $this$groupBy$iv = (Triple)$this$groupByTo$iv$iv.getKey();
            $this$groupByTo$iv$iv = eReportFormat;
            destination$iv$iv22 = false;
            List reports = (List)$this$groupByTo$iv$iv.getValue();
            Iterator iterator2 = key;
            $this$groupByTo$iv$iv = (EReportFormat)iterator2.component1();
            destination$iv$iv22 = (String)iterator2.component2();
            String message = (String)iterator2.component3();
            Iterable $this$map$iv = reports;
            boolean $i$f$map = false;
            Iterable bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                answer$iv$iv$iv = (Report)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                File file = it.getReportFile();
                collection.add(file);
            }
            List reportFiles = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            this.getLogger().info("Uploading " + reportFiles.size() + ' ' + format.name() + " report(s) to partition " + (String)partition + "...");
            if (reportFiles.isEmpty()) {
                this.getLogger().info("Skipped empty upload!");
                continue;
            }
            try {
                CommitDescriptor commitDescriptor;
                if (this.getRevision() != null) {
                    commitDescriptor = null;
                } else {
                    CommitDescriptor commitDescriptor2 = this.getCommitDescriptor();
                    commitDescriptor = commitDescriptor2;
                    Intrinsics.checkNotNull((Object)commitDescriptor2);
                }
                CommitDescriptor commitDescriptorOrNull = commitDescriptor;
                TeamscaleUploadTaskKt.retry(3, (Function0)new Function0<Unit>(this, (EReportFormat)format, reportFiles, commitDescriptorOrNull, (String)partition, message){
                    final /* synthetic */ TeamscaleUploadTask this$0;
                    final /* synthetic */ EReportFormat $format;
                    final /* synthetic */ List $reportFiles;
                    final /* synthetic */ CommitDescriptor $commitDescriptorOrNull;
                    final /* synthetic */ String $partition;
                    final /* synthetic */ String $message;

                    public final void invoke() {
                        TeamscaleClient client = new TeamscaleClient(this.this$0.getServer().getUrl(), this.this$0.getServer().getUserName(), this.this$0.getServer().getUserAccessToken(), this.this$0.getServer().getProject());
                        client.uploadReports(this.$format, (Collection)this.$reportFiles, this.$commitDescriptorOrNull, this.this$0.getRevision(), this.$partition, this.$message);
                    }
                    {
                        this.this$0 = teamscaleUploadTask;
                        this.$format = eReportFormat;
                        this.$reportFiles = list;
                        this.$commitDescriptorOrNull = commitDescriptor;
                        this.$partition = string;
                        this.$message = string2;
                        super(0);
                    }
                });
            }
            catch (ConnectException e) {
                throw (Throwable)new GradleException("Upload failed (" + e.getMessage() + ')', (Throwable)e);
            }
            catch (SocketTimeoutException e) {
                throw (Throwable)new GradleException("Upload failed (" + e.getMessage() + ')', (Throwable)e);
            }
        }
    }

    public TeamscaleUploadTask() {
        boolean bl = false;
        this.reports = new LinkedHashSet();
        this.setGroup("Teamscale");
        this.setDescription("Uploads reports to Teamscale");
    }
}

