/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale;

import com.teamscale.Report;
import com.teamscale.TeamscaleUploadTask;
import com.teamscale.TestwiseCoverageReportTaskKt;
import com.teamscale.client.TestDetails;
import com.teamscale.config.SerializableFilter;
import com.teamscale.config.extension.TeamscaleTestImpactedTaskExtension;
import com.teamscale.report.EDuplicateClassFileBehavior;
import com.teamscale.report.ReportUtils;
import com.teamscale.report.testwise.ETestArtifactFormat;
import com.teamscale.report.testwise.jacoco.JaCoCoTestwiseReportGenerator;
import com.teamscale.report.testwise.model.TestExecution;
import com.teamscale.report.testwise.model.TestwiseCoverage;
import com.teamscale.report.testwise.model.TestwiseCoverageReport;
import com.teamscale.report.testwise.model.builder.TestwiseCoverageReportBuilder;
import com.teamscale.report.util.ClasspathWildcardIncludeFilter;
import com.teamscale.report.util.ILogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u0014J\u001c\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001a2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001401J \u00102\u001a\u0004\u0018\u0001032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00140\u001b2\u0006\u00105\u001a\u000206H\u0002J&\u00107\u001a\u00020-2\u0006\u00108\u001a\u00020\u001a2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00140\u001b2\u0006\u00105\u001a\u000206H\u0002J\b\u00109\u001a\u00020-H\u0007R\u0011\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001f\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u00138G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R(\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u001b0\u00198\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138G\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0017R\u001e\u0010 \u001a\u00020!8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001e\u0010&\u001a\u00020'8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006:"}, d2={"Lcom/teamscale/TestwiseCoverageReportTask;", "Lorg/gradle/api/DefaultTask;", "()V", "agentFilter", "Lcom/teamscale/config/SerializableFilter;", "getAgentFilter", "()Lcom/teamscale/config/SerializableFilter;", "classDirs", "", "Lorg/gradle/api/file/FileCollection;", "getClassDirs", "()Ljava/util/Set;", "configuration", "Lcom/teamscale/config/extension/TeamscaleTestImpactedTaskExtension;", "getConfiguration", "()Lcom/teamscale/config/extension/TeamscaleTestImpactedTaskExtension;", "setConfiguration", "(Lcom/teamscale/config/extension/TeamscaleTestImpactedTaskExtension;)V", "reportFiles", "", "Ljava/io/File;", "kotlin.jvm.PlatformType", "getReportFiles", "()Ljava/util/List;", "reportsToArtifacts", "", "Lcom/teamscale/Report;", "", "getReportsToArtifacts", "()Ljava/util/Map;", "testArtifacts", "getTestArtifacts", "testTaskName", "", "getTestTaskName", "()Ljava/lang/String;", "setTestTaskName", "(Ljava/lang/String;)V", "uploadTask", "Lcom/teamscale/TeamscaleUploadTask;", "getUploadTask", "()Lcom/teamscale/TeamscaleUploadTask;", "setUploadTask", "(Lcom/teamscale/TeamscaleUploadTask;)V", "addTestArtifactsDirs", "", "report", "testArtifactDestination", "testArtifactDestinations", "", "buildTestwiseCoverage", "Lcom/teamscale/report/testwise/model/TestwiseCoverage;", "artifacts", "jaCoCoTestwiseReportGenerator", "Lcom/teamscale/report/testwise/jacoco/JaCoCoTestwiseReportGenerator;", "generateTestwiseCoverageReport", "reportConfig", "generateTestwiseCoverageReports", "teamscale-gradle-plugin"})
public class TestwiseCoverageReportTask
extends DefaultTask {
    @Internal
    public String testTaskName;
    @Internal
    public TeamscaleTestImpactedTaskExtension configuration;
    @Internal
    @NotNull
    private final Map<Report, List<File>> reportsToArtifacts;
    @InputFiles
    @NotNull
    private final Set<FileCollection> classDirs;
    @Internal
    public TeamscaleUploadTask uploadTask;

    @NotNull
    public final String getTestTaskName() {
        String string = this.testTaskName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testTaskName");
        }
        return string;
    }

    public final void setTestTaskName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.testTaskName = string;
    }

    @NotNull
    public final TeamscaleTestImpactedTaskExtension getConfiguration() {
        TeamscaleTestImpactedTaskExtension teamscaleTestImpactedTaskExtension = this.configuration;
        if (teamscaleTestImpactedTaskExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
        }
        return teamscaleTestImpactedTaskExtension;
    }

    public final void setConfiguration(@NotNull TeamscaleTestImpactedTaskExtension teamscaleTestImpactedTaskExtension) {
        Intrinsics.checkNotNullParameter((Object)teamscaleTestImpactedTaskExtension, (String)"<set-?>");
        this.configuration = teamscaleTestImpactedTaskExtension;
    }

    @Input
    @NotNull
    public final SerializableFilter getAgentFilter() {
        TeamscaleTestImpactedTaskExtension teamscaleTestImpactedTaskExtension = this.configuration;
        if (teamscaleTestImpactedTaskExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
        }
        return teamscaleTestImpactedTaskExtension.getAgent().getFilter();
    }

    @NotNull
    public final Map<Report, List<File>> getReportsToArtifacts() {
        return this.reportsToArtifacts;
    }

    @NotNull
    public final Set<FileCollection> getClassDirs() {
        return this.classDirs;
    }

    @NotNull
    public final TeamscaleUploadTask getUploadTask() {
        TeamscaleUploadTask teamscaleUploadTask = this.uploadTask;
        if (teamscaleUploadTask == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uploadTask");
        }
        return teamscaleUploadTask;
    }

    public final void setUploadTask(@NotNull TeamscaleUploadTask teamscaleUploadTask) {
        Intrinsics.checkNotNullParameter((Object)((Object)teamscaleUploadTask), (String)"<set-?>");
        this.uploadTask = teamscaleUploadTask;
    }

    @InputFiles
    @NotNull
    public final List<File> getTestArtifacts() {
        return CollectionsKt.flatten((Iterable)this.reportsToArtifacts.values());
    }

    /*
     * WARNING - void declaration
     */
    @OutputDirectories
    @NotNull
    public final List<File> getReportFiles() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.reportsToArtifacts.keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Report report = (Report)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = it.getReportFile().getParentFile();
            collection.add(file);
        }
        return (List)destination$iv$iv;
    }

    public final void addTestArtifactsDirs(@NotNull Report report, @NotNull File testArtifactDestination) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        Intrinsics.checkNotNullParameter((Object)testArtifactDestination, (String)"testArtifactDestination");
        List list = this.reportsToArtifacts.get(report);
        if (list == null) {
            boolean bl = false;
            list = new ArrayList();
        }
        List list2 = list;
        list2.add((File)testArtifactDestination);
        this.reportsToArtifacts.put(report, list2);
    }

    public final void addTestArtifactsDirs(@NotNull Report report, @NotNull Set<? extends File> testArtifactDestinations) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        Intrinsics.checkNotNullParameter(testArtifactDestinations, (String)"testArtifactDestinations");
        List list = this.reportsToArtifacts.get(report);
        if (list == null) {
            boolean bl = false;
            list = new ArrayList();
        }
        List list2 = list;
        list2.addAll((Collection<File>)testArtifactDestinations);
        this.reportsToArtifacts.put(report, list2);
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void generateTestwiseCoverageReports() {
        Report $this$flatMapTo$iv$iv;
        if (this.reportsToArtifacts.isEmpty()) {
            this.getLogger().info("Skipping coverage report generation (No reports configured)");
            return;
        }
        Iterable $this$flatMap$iv = this.classDirs;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            FileCollection it = (FileCollection)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Collection collection = list;
        ClasspathWildcardIncludeFilter classpathWildcardIncludeFilter = this.getAgentFilter().getPredicate();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Logger logger = project.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
        ILogger iLogger = TestwiseCoverageReportTaskKt.wrapInILogger(logger);
        EDuplicateClassFileBehavior eDuplicateClassFileBehavior = EDuplicateClassFileBehavior.IGNORE;
        ClasspathWildcardIncludeFilter classpathWildcardIncludeFilter2 = classpathWildcardIncludeFilter;
        Collection collection2 = collection;
        JaCoCoTestwiseReportGenerator jaCoCoTestwiseReportGenerator = new JaCoCoTestwiseReportGenerator(collection2, classpathWildcardIncludeFilter2, eDuplicateClassFileBehavior, iLogger);
        this.getLogger().info("Generating coverage reports...");
        Iterator<Map.Entry<Report, List<File>>> iterator2 = this.reportsToArtifacts.entrySet().iterator();
        while (iterator2.hasNext()) {
            void reportConfig;
            Map.Entry<Report, List<File>> entry;
            Map.Entry<Report, List<File>> entry2 = entry = iterator2.next();
            boolean bl = false;
            $this$flatMapTo$iv$iv = entry2.getKey();
            entry2 = entry;
            bl = false;
            List<File> artifacts = entry2.getValue();
            this.generateTestwiseCoverageReport((Report)reportConfig, artifacts, jaCoCoTestwiseReportGenerator);
        }
    }

    private final void generateTestwiseCoverageReport(Report reportConfig, List<File> artifacts, JaCoCoTestwiseReportGenerator jaCoCoTestwiseReportGenerator) {
        List testDetails = ReportUtils.readObjects((ETestArtifactFormat)ETestArtifactFormat.TEST_LIST, TestDetails[].class, artifacts);
        List testExecutions = ReportUtils.readObjects((ETestArtifactFormat)ETestArtifactFormat.TEST_EXECUTION, TestExecution[].class, artifacts);
        TestwiseCoverage testwiseCoverage2 = this.buildTestwiseCoverage(artifacts, jaCoCoTestwiseReportGenerator);
        if (testwiseCoverage2 == null) {
            return;
        }
        TestwiseCoverage testwiseCoverage3 = testwiseCoverage2;
        this.getLogger().info("Merging report with " + testDetails.size() + " Details/" + testwiseCoverage3.getTests().size() + " Coverage/" + testExecutions.size() + " Results");
        TestwiseCoverageReport report = TestwiseCoverageReportBuilder.createFrom((Collection)testDetails, (Collection)testwiseCoverage3.getTests(), (Collection)testExecutions);
        this.getLogger().info("Writing report to " + reportConfig.getReportFile());
        ReportUtils.writeTestwiseCoverageReport((File)reportConfig.getReportFile(), (TestwiseCoverageReport)report);
    }

    private final TestwiseCoverage buildTestwiseCoverage(List<File> artifacts, JaCoCoTestwiseReportGenerator jaCoCoTestwiseReportGenerator) {
        List jacocoExecutionData = ReportUtils.listFiles((ETestArtifactFormat)ETestArtifactFormat.JACOCO, artifacts);
        if (jacocoExecutionData.isEmpty()) {
            this.getLogger().error("No execution data provided!");
            return null;
        }
        this.getLogger().info("Generating testwise coverage for " + jacocoExecutionData);
        TestwiseCoverage testwiseCoverage2 = new TestwiseCoverage();
        for (File file : jacocoExecutionData) {
            testwiseCoverage2.add(jaCoCoTestwiseReportGenerator.convert(file));
        }
        return testwiseCoverage2;
    }

    public TestwiseCoverageReportTask() {
        boolean bl = false;
        this.reportsToArtifacts = new LinkedHashMap();
        bl = false;
        this.classDirs = new LinkedHashSet();
        this.setGroup("Teamscale");
        this.setDescription("Generates a testwise coverage report");
    }
}

