/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.assessment;

import java.awt.Color;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.color.ECCSMColor;

public class AssessmentUtils {
    private static final NumberFormat PLUS_MINUS_NUMBERFORMAT = new DecimalFormat("+#;-#");
    private static final double RELATIVE_DELTA_ZERO_THRESHOLD = 5.0E-4;

    public static Color getColor(ETrafficLightColor color) {
        switch (color) {
            case RED: {
                return ECCSMColor.RED.getColor();
            }
            case YELLOW: {
                return ECCSMColor.YELLOW.getColor();
            }
            case GREEN: {
                return ECCSMColor.GREEN.getColor();
            }
            case BASELINE: {
                return ECCSMColor.LIGHT_BLUE.getColor();
            }
        }
        return ECCSMColor.DARK_GRAY.getColor();
    }

    public static int compareAssessments(Assessment o1, Assessment o2) {
        double red1 = (double)o1.getColorFrequency(ETrafficLightColor.RED) / (double)o1.getSize();
        double red2 = (double)o2.getColorFrequency(ETrafficLightColor.RED) / (double)o2.getSize();
        double yellow1 = (double)o1.getColorFrequency(ETrafficLightColor.YELLOW) / (double)o1.getSize();
        double yellow2 = (double)o2.getColorFrequency(ETrafficLightColor.YELLOW) / (double)o2.getSize();
        double yFactor = 0.4;
        return Double.compare(red1 + yFactor * yellow1, red2 + yFactor * yellow2);
    }

    public static String calculateAndFormatDelta(Assessment oldAssessment, Assessment newAssessment) {
        ArrayList<String> builder = new ArrayList<String>();
        for (ETrafficLightColor color : ETrafficLightColor.getTrafficLightColors()) {
            if (AssessmentUtils.calculateRelativeFrequencyDelta(color, oldAssessment, newAssessment) == 0.0) continue;
            builder.add(AssessmentUtils.calculateAndFormatDelta(color, oldAssessment, newAssessment));
        }
        return String.join((CharSequence)", ", builder);
    }

    private static String calculateAndFormatAbsoluteDelta(ETrafficLightColor color, Assessment oldAssessment, Assessment newAssessment) {
        return PLUS_MINUS_NUMBERFORMAT.format(newAssessment.getColorFrequency(color) - oldAssessment.getColorFrequency(color));
    }

    private static String calculateAndFormatRelativeDelta(ETrafficLightColor color, Assessment oldAssessment, Assessment newAssessment) {
        double colorRelativeDelta = AssessmentUtils.calculateRelativeFrequencyDelta(color, oldAssessment, newAssessment);
        if (Math.abs(colorRelativeDelta) < 5.0E-4) {
            return "+0.0%";
        }
        String colorRelativeDeltaFormatted = Assessment.PERCENT_FORMAT.format(colorRelativeDelta);
        if (colorRelativeDelta > 0.0) {
            colorRelativeDeltaFormatted = "+" + colorRelativeDeltaFormatted;
        }
        return colorRelativeDeltaFormatted;
    }

    private static String calculateAndFormatDelta(ETrafficLightColor color, Assessment oldAssessment, Assessment newAssessment) {
        return color.getShortDisplayText() + ": " + AssessmentUtils.calculateAndFormatAbsoluteDelta(color, oldAssessment, newAssessment) + " (" + AssessmentUtils.calculateAndFormatRelativeDelta(color, oldAssessment, newAssessment) + ")";
    }

    protected static double calculateRelativeFrequencyDelta(ETrafficLightColor color, Assessment oldAssessment, Assessment newAssessment) {
        return newAssessment.getRelativeColorFrequency(color) - oldAssessment.getRelativeColorFrequency(color);
    }
}

