/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.cache4j;

import org.conqat.lib.commons.cache4j.BasicCache;
import org.conqat.lib.commons.cache4j.ICache;
import org.conqat.lib.commons.cache4j.SynchronizedCache;
import org.conqat.lib.commons.cache4j.ThreadLocalCache;
import org.conqat.lib.commons.cache4j.backend.ICacheBackend;
import org.conqat.lib.commons.factory.IParameterizedFactory;

public enum ECacheThreadSupport {
    NONE,
    SYNCHRONIZED,
    THREADLOCAL;


    public <K, V, X extends Exception> ICache<K, V, X> createCache(String name, IParameterizedFactory<V, K, X> factory, ICacheBackend<K, V> backend) {
        switch (this) {
            case NONE: {
                return new BasicCache<K, V, X>(name, factory, backend);
            }
            case SYNCHRONIZED: {
                return new SynchronizedCache<K, V, X>(name, factory, backend);
            }
            case THREADLOCAL: {
                return new ThreadLocalCache<K, V, X>(name, factory, backend);
            }
        }
        throw new AssertionError((Object)("Unknown enum value: " + (Object)((Object)this)));
    }
}

