/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.cache4j.backend;

import org.conqat.lib.commons.cache4j.backend.ICacheBackend;
import org.conqat.lib.commons.cache4j.backend.LRUCacheBackend;
import org.conqat.lib.commons.cache4j.backend.NoneCacheBackend;
import org.conqat.lib.commons.cache4j.backend.SingleElementCacheBackend;
import org.conqat.lib.commons.cache4j.backend.SoftRefCacheBackend;
import org.conqat.lib.commons.cache4j.backend.UnlimitedCacheBackend;

public enum ECachingStrategy {
    OFF,
    SINGLE,
    LRU,
    MEMORY,
    UNLIMITED;


    public <K, V> ICacheBackend<K, V> getBackend(int parameter) {
        switch (this) {
            case OFF: {
                return new NoneCacheBackend();
            }
            case SINGLE: {
                return new SingleElementCacheBackend();
            }
            case LRU: {
                if (parameter < 1) {
                    parameter = 10;
                }
                return new LRUCacheBackend(parameter);
            }
            case MEMORY: {
                return new SoftRefCacheBackend();
            }
            case UNLIMITED: {
                return new UnlimitedCacheBackend();
            }
        }
        throw new AssertionError((Object)("Unknown enum value: " + (Object)((Object)this)));
    }
}

