/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class BasicPatternList
extends ArrayList<Pattern>
implements Serializable {
    private static final long serialVersionUID = 1L;

    public BasicPatternList() {
    }

    public BasicPatternList(Collection<? extends Pattern> patterns) {
        super(patterns);
    }

    public BasicPatternList(Pattern ... patterns) {
        this((Collection<? extends Pattern>)Arrays.asList(patterns));
    }

    public boolean emptyOrMatchesAny(String s) {
        return this.isEmpty() || this.matchesAny(s);
    }

    public boolean matchesAny(String s) {
        for (Pattern p : this) {
            CCSMAssert.isNotNull((Object)p, "Encountered null pattern!");
            if (!p.matcher(s).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean findsAnyIn(String s) {
        for (Pattern p : this) {
            CCSMAssert.isNotNull((Object)p, "Encountered null pattern!");
            if (!p.matcher(s).find()) continue;
            return true;
        }
        return false;
    }

    public List<String> asStringList() {
        ArrayList<String> patterns = new ArrayList<String>();
        for (Pattern pattern : this) {
            patterns.add(pattern.pattern());
        }
        return patterns;
    }
}

