/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ISortableData;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SortableDataUtils;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.collections.UnmodifiableSortedMap;
import org.conqat.lib.commons.collections.UnmodifiableSortedSet;
import org.conqat.lib.commons.string.StringUtils;

public class CollectionUtils {
    private static final UnmodifiableList<?> EMPTY_LIST = new UnmodifiableList(Collections.emptyList());
    private static final UnmodifiableMap<?, ?> EMPTY_MAP = new UnmodifiableMap(Collections.emptyMap());
    private static final UnmodifiableSet<?> EMPTY_SET = new UnmodifiableSet(Collections.emptySet());
    public static final String MULTI_VALUE_DELIMITER = ",";

    @SafeVarargs
    public static <T> HashSet<T> asHashSet(T ... elements) {
        HashSet result = new HashSet(elements.length);
        Collections.addAll(result, elements);
        return result;
    }

    @SafeVarargs
    public static <K, V> UnmodifiableMap<K, V> asMap(Pair<K, V> ... pairs) {
        return CollectionUtils.asMap(new HashMap(), pairs);
    }

    @SafeVarargs
    public static <K, V> UnmodifiableMap<K, V> asMap(Map<K, V> baseMap, Pair<K, V> ... pairs) {
        for (Pair<K, V> pair : pairs) {
            baseMap.put(pair.getFirst(), pair.getSecond());
        }
        return CollectionUtils.asUnmodifiable(baseMap);
    }

    @SafeVarargs
    public static <T> UnmodifiableSet<T> asUnmodifiableHashSet(T ... elements) {
        return new UnmodifiableSet<T>(CollectionUtils.asHashSet(elements));
    }

    public static <T> UnmodifiableCollection<T> asUnmodifiable(Collection<T> c) {
        return new UnmodifiableCollection<T>(c);
    }

    public static <T> UnmodifiableList<T> asUnmodifiable(List<T> l) {
        return new UnmodifiableList<T>(l);
    }

    public static <S, T> UnmodifiableMap<S, T> asUnmodifiable(Map<S, T> m) {
        return new UnmodifiableMap<S, T>(m);
    }

    public static <T> UnmodifiableSet<T> asUnmodifiable(Set<T> s) {
        return new UnmodifiableSet<T>(s);
    }

    public static <S, T> UnmodifiableSortedMap<S, T> asUnmodifiable(SortedMap<S, T> m) {
        return new UnmodifiableSortedMap<S, T>(m);
    }

    public static <T> UnmodifiableSortedSet<T> asUnmodifiable(SortedSet<T> s) {
        return new UnmodifiableSortedSet<T>(s);
    }

    public static <T> UnmodifiableList<T> emptyList() {
        return EMPTY_LIST;
    }

    public static <S, T> UnmodifiableMap<S, T> emptyMap() {
        return EMPTY_MAP;
    }

    public static <T> UnmodifiableSet<T> emptySet() {
        return EMPTY_SET;
    }

    public static <T extends Comparable<? super T>> ArrayList<T> sort(Collection<T> collection) {
        ArrayList<T> list = new ArrayList<T>(collection);
        Collections.sort(list);
        return list;
    }

    public static <T> ArrayList<T> reverse(Collection<T> list) {
        ArrayList<T> reversed = new ArrayList<T>(list);
        Collections.reverse(reversed);
        return reversed;
    }

    public static <T> Set<T> getDuplicates(List<T> values) {
        HashSet<T> duplicates = new HashSet<T>();
        HashSet<T> temp = new HashSet<T>();
        for (T key : values) {
            if (temp.add(key)) continue;
            duplicates.add(key);
        }
        return duplicates;
    }

    public static <T, R> List<R> map(Collection<T> list, Function<? super T, ? extends R> mapper) {
        ArrayList<R> result = new ArrayList<R>(list.size());
        for (T entry : list) {
            result.add(mapper.apply(entry));
        }
        return result;
    }

    public static <T, R> Set<R> mapToSet(Collection<T> list, Function<? super T, ? extends R> mapper) {
        HashSet<R> result = new HashSet<R>();
        for (T entry : list) {
            result.add(mapper.apply(entry));
        }
        return result;
    }

    public static <K1, V1, K2, V2> Map<K2, V2> map(Map<K1, V1> map, Function<K1, ? extends K2> keyMapper, Function<V1, ? extends V2> valueMapper) {
        HashMap result = new HashMap(map.size());
        map.forEach((key, value) -> result.put(keyMapper.apply(key), valueMapper.apply(value)));
        return result;
    }

    public static <T, R> List<R> map(T[] array, Function<? super T, ? extends R> mapper) {
        return CollectionUtils.map(Arrays.asList(array), mapper);
    }

    public static <T, R> List<R> mapDistinct(Collection<T> list, Function<? super T, ? extends R> mapper) {
        HashSet<R> encounteredItems = new HashSet<R>();
        ArrayList<R> result = new ArrayList<R>();
        for (T entry : list) {
            R resultItem = mapper.apply(entry);
            if (!encounteredItems.add(resultItem)) continue;
            result.add(resultItem);
        }
        return result;
    }

    public static <T, R, E extends Exception> List<R> mapWithException(Collection<T> list, FunctionWithException<? super T, ? extends R, ? extends E> mapper) throws E {
        ArrayList<R> result = new ArrayList<R>(list.size());
        for (T entry : list) {
            result.add(mapper.apply(entry));
        }
        return result;
    }

    public static <T, R, E extends Exception> List<R> mapWithException(T[] array, FunctionWithException<? super T, ? extends R, ? extends E> mapper) throws E {
        return CollectionUtils.mapWithException(Arrays.asList(array), mapper);
    }

    public static <T> ArrayList<T> getIndices(List<T> list, List<Integer> indices) {
        ArrayList<T> filteredList = new ArrayList<T>();
        for (int index : indices) {
            filteredList.add(list.get(index));
        }
        return filteredList;
    }

    public static <T> List<T> returnListWithoutGivenIndices(List<T> elements, Set<Integer> indices) {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < elements.size(); ++i) {
            if (indices.contains(i)) continue;
            result.add(elements.get(i));
        }
        return result;
    }

    public static List<Integer> getNullIndices(List<@Nullable ?> list) {
        ArrayList<Integer> nullIndices = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != null) continue;
            nullIndices.add(i);
        }
        return nullIndices;
    }

    public static boolean isValidIndex(int index, List<?> list) {
        return index >= 0 && index < list.size();
    }

    public static <T> void removeAll(Set<T> set, List<T> itemsToBeRemoved) {
        if (itemsToBeRemoved.size() >= set.size()) {
            itemsToBeRemoved.forEach(set::remove);
        } else {
            set.removeAll(itemsToBeRemoved);
        }
    }

    public static <T> List<T> filter(Collection<T> collection, Predicate<? super T> filter) {
        ArrayList<T> result = new ArrayList<T>();
        for (T entry : collection) {
            if (!filter.test(entry)) continue;
            result.add(entry);
        }
        return result;
    }

    public static <T, E extends Exception> List<T> filterWithException(Collection<T> collection, FunctionWithException<? super T, Boolean, E> filter) throws E {
        ArrayList<T> result = new ArrayList<T>();
        for (T entry : collection) {
            if (!filter.apply(entry).booleanValue()) continue;
            result.add(entry);
        }
        return result;
    }

    public static <T> Set<T> filterToSet(Collection<T> collection, Predicate<? super T> filter) {
        HashSet<T> result = new HashSet<T>();
        for (T entry : collection) {
            if (!filter.test(entry)) continue;
            result.add(entry);
        }
        return result;
    }

    public static <T, R> List<R> filterAndMap(Collection<T> list, Predicate<? super T> filter, Function<? super T, ? extends R> mapper) {
        return CollectionUtils.filterAndMapWithException(list, filter::test, mapper::apply);
    }

    public static <T, R, X1 extends Exception, X2 extends Exception> List<R> filterAndMapWithException(Collection<T> list, PredicateWithException<? super T, X1> filter, FunctionWithException<? super T, ? extends R, X2> mapper) throws X1, X2 {
        ArrayList<R> result = new ArrayList<R>();
        for (T entry : list) {
            if (!filter.test(entry)) continue;
            result.add(mapper.apply(entry));
        }
        return result;
    }

    public static <T> List<T> remove(List<T> list, int index) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.remove(index);
        return result;
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator<? super T> comparator) {
        ArrayList<T> list = new ArrayList<T>(collection);
        list.sort(comparator);
        return list;
    }

    public static <T extends Comparable<? super T>> UnmodifiableList<T> asSortedUnmodifiableList(Collection<T> collection) {
        return CollectionUtils.asUnmodifiable(CollectionUtils.sort(collection));
    }

    public static <T> T getAny(Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    public static <T> T[] toArray(Collection<? extends T> collection, Class<T> type) {
        Object[] result = (Object[])Array.newInstance(type, collection.size());
        Iterator<T> it = collection.iterator();
        for (int i = 0; i < collection.size(); ++i) {
            result[i] = it.next();
        }
        return result;
    }

    public static <T> T[] copyArray(T[] original) {
        return Arrays.copyOf(original, original.length);
    }

    public static <T> List<ImmutablePair<T, T>> computeUnorderedPairs(Collection<T> collection) {
        ArrayList<T> elements = new ArrayList<T>(collection);
        ArrayList<ImmutablePair<T, T>> pairs = new ArrayList<ImmutablePair<T, T>>();
        int size = elements.size();
        for (int firstIndex = 0; firstIndex < size; ++firstIndex) {
            for (int secondIndex = firstIndex + 1; secondIndex < size; ++secondIndex) {
                pairs.add(new ImmutablePair(elements.get(firstIndex), elements.get(secondIndex)));
            }
        }
        return pairs;
    }

    public static <T> @Nullable T getLast(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list instanceof Deque) {
            return (T)((Deque)((Object)list)).getLast();
        }
        return list.get(list.size() - 1);
    }

    public static <T> @Nullable List<T> getRest(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.subList(1, list.size());
    }

    public static <S extends Comparable<S>, T> void sortByFirst(PairList<S, T> list) {
        CollectionUtils.sortByFirst(list, Comparator.naturalOrder());
    }

    public static <S, T> void sortByFirst(final PairList<S, T> list, final Comparator<S> comparator) {
        SortableDataUtils.sort(new ISortableData(){

            @Override
            public void swap(int i, int j) {
                list.swapEntries(i, j);
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean isLess(int i, int j) {
                int compare = comparator.compare(list.getFirst(i), list.getFirst(j));
                if (compare == 0) {
                    return i < j;
                }
                return compare < 0;
            }
        });
    }

    public static <T> List<T> asRandomAccessList(Collection<T> list) {
        if (list instanceof List && list instanceof RandomAccess) {
            return (List)list;
        }
        return new ArrayList<T>(list);
    }

    @SafeVarargs
    private static <T, C extends Collection<T>> C unionCollection(Supplier<C> collectionSupplier, @Nullable Collection<T> collection1, Collection<T> ... furtherCollections) {
        Collection result = (Collection)collectionSupplier.get();
        if (collection1 != null) {
            result.addAll(collection1);
        }
        for (Collection<T> collection : furtherCollections) {
            if (collection == null) continue;
            result.addAll(collection);
        }
        return (C)result;
    }

    @SafeVarargs
    public static <T> HashSet<T> unionSet(Collection<T> collection1, Collection<T> ... furtherCollections) {
        return CollectionUtils.unionCollection(HashSet::new, collection1, furtherCollections);
    }

    @SafeVarargs
    public static <T extends Enum<T>> EnumSet<T> enumUnionSet(EnumSet<T> initialSet, EnumSet<T> ... otherSets) {
        EnumSet<T> union = EnumSet.copyOf(initialSet);
        for (EnumSet<T> other : otherSets) {
            union.addAll(other);
        }
        return union;
    }

    @SafeVarargs
    public static <T> ArrayList<T> unionList(Collection<T> collection1, Collection<T> ... furtherCollections) {
        return CollectionUtils.unionCollection(ArrayList::new, collection1, furtherCollections);
    }

    public static <T> HashSet<T> unionSetAll(Collection<? extends Collection<T>> sets) {
        HashSet<T> result = new HashSet<T>();
        for (Collection<T> set : sets) {
            result.addAll(set);
        }
        return result;
    }

    public static <T> Set<T> subtract(@Nullable Collection<T> collection, @Nullable Collection<T> elementsToRemove) {
        HashSet<T> result = new HashSet<T>();
        if (collection != null) {
            result.addAll(collection);
        }
        if (elementsToRemove != null) {
            result.removeAll(elementsToRemove);
        }
        return result;
    }

    public static <T> void addAllSafe(Collection<T> collection1, @Nullable Collection<T> collection2) {
        if (collection2 != null) {
            collection1.addAll(collection2);
        }
    }

    @SafeVarargs
    public static <T> HashSet<T> intersectionSet(Collection<T> collection1, Collection<T> ... furtherCollections) {
        HashSet<T> result = new HashSet<T>(collection1);
        for (Collection<T> collection : furtherCollections) {
            if (collection instanceof Set) {
                result.retainAll(collection);
                continue;
            }
            result.retainAll(new HashSet<T>(collection));
        }
        return result;
    }

    @SafeVarargs
    public static <T> HashSet<T> differenceSet(Collection<T> collection1, Collection<? extends T> ... furtherCollections) {
        HashSet<T> result = new HashSet<T>(collection1);
        for (Collection<T> collection : furtherCollections) {
            if (collection instanceof Set) {
                result.removeAll(collection);
                continue;
            }
            result.removeAll(new HashSet<T>(collection));
        }
        return result;
    }

    public static boolean isNullOrEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNullOrEmpty(@Nullable PairList<?, ?> pairs) {
        return pairs == null || pairs.isEmpty();
    }

    public static void truncateEnd(List<?> list, int numElements) {
        if (list.size() > numElements) {
            list.subList(numElements, list.size()).clear();
        }
    }

    public static <S> List<Set<S>> divideEvenlyIntoKSubsets(Set<S> set, int k, Random rnd) {
        int n = set.size();
        CCSMAssert.isTrue(n >= k, "The size of the set must be at least k");
        CCSMAssert.isTrue(k > 0, "k must be greater than 0");
        ArrayList<S> shuffled = new ArrayList<S>(set);
        Collections.shuffle(shuffled, rnd);
        ArrayList<Set<S>> result = new ArrayList<Set<S>>();
        int subsetSize = n / k + 1;
        for (int i = 0; i < n % k; ++i) {
            result.add(new HashSet(shuffled.subList(i * subsetSize, (i + 1) * subsetSize)));
        }
        int offset = n % k * subsetSize;
        subsetSize = n / k;
        for (int i = 0; i < k - n % k; ++i) {
            result.add(new HashSet(shuffled.subList(offset + i * subsetSize, offset + (i + 1) * subsetSize)));
        }
        return result;
    }

    public static <T> List<List<T>> getAllPermutations(T ... elements) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        CollectionUtils.permute(Arrays.asList(elements), 0, result);
        return result;
    }

    private static <T> void permute(List<T> list, int index, List<List<T>> result) {
        for (int i = index; i < list.size(); ++i) {
            Collections.swap(list, i, index);
            CollectionUtils.permute(list, index + 1, result);
            Collections.swap(list, index, i);
        }
        if (index == list.size() - 1) {
            result.add(new ArrayList<T>(list));
        }
    }

    public static <T> List<List<T>> getPowerSet(List<T> input) {
        return CollectionUtils.getPowerSet(input, 0);
    }

    private static <T> List<List<T>> getPowerSet(List<T> input, int start) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (start >= input.size()) {
            result.add(new ArrayList());
        } else {
            T element = input.get(start);
            for (List<T> list : CollectionUtils.getPowerSet(input, start + 1)) {
                ArrayList<T> copy = new ArrayList<T>();
                copy.add(element);
                copy.addAll(list);
                result.add(list);
                result.add(copy);
            }
        }
        return result;
    }

    public static <T> List<T> emptyIfNull(@Nullable List<T> input) {
        if (input == null) {
            return CollectionUtils.emptyList();
        }
        return input;
    }

    public static <T> Set<T> emptyIfNull(@Nullable Set<T> input) {
        if (input == null) {
            return CollectionUtils.emptySet();
        }
        return input;
    }

    public static <K, V, M extends Map<K, V>> M emptyIfNull(@Nullable M input, Supplier<M> supplier) {
        return Optional.ofNullable(input).orElseGet(supplier);
    }

    public static <T> T[] removeElementFromArray(T element, T[] array) {
        ArrayList<T> result = new ArrayList<T>(Arrays.asList(array));
        result.remove(element);
        return CollectionUtils.toArray(result, element.getClass());
    }

    public static <T> List<T> filterNullEntries(Collection<@Nullable T> list) {
        return CollectionUtils.filter(list, Objects::nonNull);
    }

    public static <T> List<T> filterNullEntries(@Nullable T[] array) {
        return CollectionUtils.filterNullEntries(Arrays.asList(array));
    }

    public static <T> T[] concatenateArrays(T[] a, T[] b) {
        int length1 = a.length;
        int length2 = b.length;
        Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), length1 + length2);
        System.arraycopy(a, 0, newArray, 0, length1);
        System.arraycopy(b, 0, newArray, length1, length2);
        return newArray;
    }

    public static <T> boolean anyMatch(Collection<? extends T> collection, Predicate<T> predicate) {
        for (T element : collection) {
            if (!predicate.test(element)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean allMatch(Collection<? extends T> collection, Predicate<T> predicate) {
        for (T element : collection) {
            if (predicate.test(element)) continue;
            return false;
        }
        return true;
    }

    public static <T> Pair<List<T>, List<T>> bottomSort(Collection<T> collection, Function<T, Collection<T>> getSuccessors) {
        Pair<List<T>, List<T>> topSortResult = CollectionUtils.topSort(collection, getSuccessors);
        return Pair.createPair(CollectionUtils.reverse((Collection)topSortResult.getFirst()), CollectionUtils.reverse((Collection)topSortResult.getSecond()));
    }

    public static <T> List<T> bottomSortNoCyclesExpected(Collection<T> collection, Function<T, Collection<T>> getSuccessors) {
        Pair<List<T>, List<T>> topSortResult = CollectionUtils.bottomSort(collection, getSuccessors);
        CCSMAssert.isTrue(((List)topSortResult.getSecond()).isEmpty(), "Expected no cycles for bottom sort of " + collection + " but encountred cycle " + topSortResult.getSecond());
        return (List)topSortResult.getFirst();
    }

    public static <T> List<T> topSortNoCyclesExpected(Collection<T> collection, Function<T, Collection<T>> getSuccessors) {
        Pair<List<T>, List<T>> topSortResult = CollectionUtils.topSort(collection, getSuccessors);
        CCSMAssert.isTrue(((List)topSortResult.getSecond()).isEmpty(), "Expected no cycles for top sort of " + collection + " but encountred cycle " + topSortResult.getSecond());
        return (List)topSortResult.getFirst();
    }

    public static <T> Pair<List<T>, List<T>> topSort(Collection<T> collection, Function<T, Collection<T>> getSuccessors) {
        UnmodifiableSet<T> inputSet = CollectionUtils.asUnmodifiable(new HashSet<T>(collection));
        CounterSet numUnhandledPredecessors = new CounterSet();
        for (T element2 : collection) {
            Collection<T> successors = getSuccessors.apply(element2);
            if (successors == null) continue;
            successors.stream().filter(inputSet::contains).forEach(numUnhandledPredecessors::inc);
        }
        Deque freeElements = collection.stream().filter(element -> !numUnhandledPredecessors.contains(element)).collect(Collectors.toCollection(ArrayDeque::new));
        ArrayList result = new ArrayList(collection.size());
        while (!freeElements.isEmpty()) {
            Object element3 = freeElements.remove();
            result.add(element3);
            CollectionUtils.handleTopSortElementSuccessors(getSuccessors.apply(element3), numUnhandledPredecessors, freeElements, inputSet);
        }
        List cycle = numUnhandledPredecessors.getKeys().stream().sorted().collect(Collectors.toList());
        return new Pair<List<T>, List<T>>(result, cycle);
    }

    private static <T> void handleTopSortElementSuccessors(@Nullable Collection<? extends T> successors, CounterSet<T> numUnhandledPredecessors, Deque<T> freeElements, UnmodifiableSet<T> filterSet) {
        if (successors != null) {
            successors.stream().filter(filterSet::contains).forEach(successor -> {
                numUnhandledPredecessors.inc(successor, -1);
                if (numUnhandledPredecessors.getValue(successor) <= 0) {
                    freeElements.add(successor);
                    numUnhandledPredecessors.remove(successor);
                }
            });
        }
    }

    public static <T> Pair<List<T>, Set<T>> topSortRemoveCycles(Collection<T> collection, Function<T, @Nullable Collection<T>> getSuccessors, Function<T, Collection<T>> getPredecessors) {
        Set removedCycleElements = collection.stream().filter(node -> {
            Collection successors = (Collection)getSuccessors.apply(node);
            return successors != null && successors.contains(node);
        }).collect(Collectors.toSet());
        ArrayList<T> reducedCollection = new ArrayList<T>(collection);
        reducedCollection.removeIf(removedCycleElements::contains);
        Pair<List<T>, List<T>> topSorted = CollectionUtils.topSort(reducedCollection, getSuccessors);
        if (((List)topSorted.getSecond()).isEmpty()) {
            return new Pair<List<T>, Set<T>>(topSorted.getFirst(), removedCycleElements);
        }
        ArrayList tailElements = new ArrayList();
        List headElements = (List)topSorted.getFirst();
        List cycle = (List)topSorted.getSecond();
        while (!cycle.isEmpty()) {
            Pair<List<T>, List<T>> inverseTopSortedCycle = CollectionUtils.topSort(cycle, getPredecessors);
            tailElements.addAll((Collection)inverseTopSortedCycle.getFirst());
            cycle = (List)inverseTopSortedCycle.getSecond();
            if (!cycle.isEmpty()) {
                removedCycleElements.add(cycle.remove(cycle.size() - 1));
            }
            Pair<List<T>, List<T>> topSortedCycle = CollectionUtils.topSort(cycle, getSuccessors);
            headElements.addAll((Collection)topSortedCycle.getFirst());
            cycle = (List)topSortedCycle.getSecond();
        }
        headElements.addAll(CollectionUtils.reverse(tailElements));
        return new Pair<List<T>, Set<T>>(headElements, removedCycleElements);
    }

    public static List<String> toStringSet(Collection<?> input) {
        return input.stream().map(Object::toString).collect(Collectors.toList());
    }

    public static <L extends List<T>, T extends Comparable<T>> Comparator<L> getListComparator() {
        return CollectionUtils.getListComparator(Comparable::compareTo);
    }

    public static <L extends List<T>, T> Comparator<L> getListComparator(Comparator<T> elementComparator) {
        return (o1, o2) -> {
            if (o1.size() != o2.size()) {
                return o1.size() - o2.size();
            }
            for (int i = 0; i < o1.size(); ++i) {
                int currentComparison = elementComparator.compare(o1.get(i), o2.get(i));
                if (currentComparison == 0) continue;
                return currentComparison;
            }
            return 0;
        };
    }

    public static <P extends Pair<T, S>, T extends Comparable<T>, S extends Comparable<S>> Comparator<P> getPairComparator() {
        return Comparator.comparing(ImmutablePair::getFirst).thenComparing(ImmutablePair::getSecond);
    }

    public static <T> Consumer<T> emptyConsumer() {
        return x -> {};
    }

    public static <S, T> BiConsumer<S, T> emptyBiConsumer() {
        return (x, y) -> {};
    }

    public static List<String> parseMultiValueStringToList(String valueList) {
        List<String> lines = StringUtils.splitWithEscapeCharacter(valueList, "\\n");
        return CollectionUtils.parseMultiValueStringToList(lines);
    }

    public static List<String> parseMultiValueStringToList(List<String> valueListLines) {
        ArrayList<String> results = new ArrayList<String>();
        for (String line : valueListLines) {
            List<String> result = StringUtils.splitWithEscapeCharacter(line, MULTI_VALUE_DELIMITER);
            for (String value : result) {
                if (!StringUtils.isEmpty(value)) continue;
                throw new IllegalArgumentException("Found duplicate comma (empty value) in list: " + valueListLines);
            }
            results.addAll(result);
        }
        return results;
    }

    public static <T1, T2, RESULT> List<RESULT> combine(Collection<T1> firstValues, Collection<T2> secondValues, BiFunction<T1, T2, RESULT> combineFunction) {
        ArrayList resultList = new ArrayList(firstValues.size());
        return CollectionUtils.combine(firstValues, secondValues, resultList, combineFunction);
    }

    public static <T1, T2, RESULT, COLLECTION extends Collection<RESULT>> COLLECTION combine(Collection<T1> firstValues, Collection<T2> secondValues, COLLECTION resultCollection, BiFunction<T1, T2, RESULT> combineFunction) {
        CCSMAssert.isTrue(firstValues.size() == secondValues.size(), "Can only combine collections of the same size.");
        Iterator<T1> firstIterator = firstValues.iterator();
        Iterator<T2> secondIterator = secondValues.iterator();
        while (firstIterator.hasNext()) {
            resultCollection.add(combineFunction.apply(firstIterator.next(), secondIterator.next()));
        }
        return resultCollection;
    }

    public static <T1, T2> void forEach(Collection<T1> firstValues, Collection<T2> secondValues, BiConsumer<T1, T2> combineFunction) {
        CCSMAssert.isTrue(firstValues.size() == secondValues.size(), "Can only combine collections of the same size.");
        Iterator<T1> firstIterator = firstValues.iterator();
        Iterator<T2> secondIterator = secondValues.iterator();
        while (firstIterator.hasNext()) {
            combineFunction.accept(firstIterator.next(), secondIterator.next());
        }
    }

    public static <T1, T2, E extends Exception> void forEachWithException(Collection<T1> firstValues, Collection<T2> secondValues, BiConsumerWithException<? super T1, ? super T2, E> combineFunction) throws E {
        CCSMAssert.isTrue(firstValues.size() == secondValues.size(), "Can only combine collections of the same size.");
        Iterator<T1> firstIterator = firstValues.iterator();
        Iterator<T2> secondIterator = secondValues.iterator();
        while (firstIterator.hasNext()) {
            combineFunction.accept(firstIterator.next(), secondIterator.next());
        }
    }

    public static <T> int indexOfFirstMatch(List<T> list, Predicate<T> predicate) {
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            if (!predicate.test(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static <K, V> Map<K, V> zipAsMap(List<K> first, List<V> second) {
        CCSMAssert.isTrue(first.size() == second.size(), "Need the same number of elements in the given lists. Found " + first.size() + " / " + second.size());
        HashMap<K, V> resultMap = new HashMap<K, V>();
        for (int i = 0; i < first.size(); ++i) {
            resultMap.put(first.get(i), second.get(i));
        }
        return resultMap;
    }

    public static <T> List<T> subListFrom(List<T> list, int fromIndex) {
        return list.subList(fromIndex, list.size());
    }

    public static <T> ArrayList<T> repeat(Function<Integer, T> factory, int count) {
        CCSMAssert.isFalse(count < 0, () -> "Repeating objects for negative number " + count + " of objects is not possible.");
        ArrayList<T> result = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            result.add(factory.apply(count));
        }
        return result;
    }

    public static <T> Predicate<Map.Entry<T, ?>> onKey(Predicate<? super T> predicate) {
        return entry -> predicate.test((Object)entry.getKey());
    }

    public static <T> Predicate<Map.Entry<?, T>> onValue(Predicate<? super T> predicate) {
        return entry -> predicate.test((Object)entry.getValue());
    }

    public static <K, V> @Nullable Map<V, K> inverseMap(@Nullable Map<K, V> sourceMap) {
        if (sourceMap == null) {
            return null;
        }
        return sourceMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public static <T> @Nullable List<T> limit(@Nullable List<T> list, int n) {
        if (list == null || list.size() <= n) {
            return list;
        }
        return list.subList(0, n);
    }

    @FunctionalInterface
    public static interface PredicateWithException<T, E extends Exception> {
        public boolean test(T var1) throws E;
    }

    @FunctionalInterface
    public static interface BiFunctionWithException<T, U, R, E extends Exception> {
        public R apply(T var1, U var2) throws E;
    }

    @FunctionalInterface
    public static interface BiConsumerWithTwoExceptions<S, T, E1 extends Exception, E2 extends Exception> {
        public void accept(S var1, T var2) throws E1, E2;
    }

    @FunctionalInterface
    public static interface BiConsumerWithException<S, T, E extends Exception> {
        public void accept(S var1, T var2) throws E;
    }

    @FunctionalInterface
    public static interface ConsumerWithTwoExceptions<T, E1 extends Exception, E2 extends Exception> {
        public void accept(T var1) throws E1, E2;
    }

    @FunctionalInterface
    public static interface ConsumerWithException<T, E extends Exception> {
        public void accept(T var1) throws E;
    }

    @FunctionalInterface
    public static interface FunctionWithTwoExceptions<T, R, E1 extends Exception, E2 extends Exception> {
        public R apply(T var1) throws E1, E2;

        public static <T, E extends Exception> FunctionWithException<T, T, E> identity() {
            return t -> t;
        }
    }

    @FunctionalInterface
    public static interface FunctionWithException<T, R, E extends Exception> {
        public R apply(T var1) throws E;

        public static <T, E extends Exception> FunctionWithException<T, T, E> identity() {
            return t -> t;
        }
    }

    @FunctionalInterface
    public static interface SupplierWithException<T, E extends Exception> {
        public T get() throws E;
    }
}

