/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.conqat.lib.commons.collections.SetMap;

public class SetMapCollector<T, K, V>
implements Collector<T, SetMap<K, V>, SetMap<K, V>> {
    private final Function<T, K> keyMapper;
    private final Function<T, V> valueMapper;

    public SetMapCollector(Function<T, K> keyMapper, Function<T, V> valueMapper) {
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
    }

    public static <T, K, V> SetMapCollector<T, K, V> collect(Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return new SetMapCollector<T, K, V>(keyMapper, valueMapper);
    }

    public static <T, K> SetMapCollector<T, K, T> groupingBy(Function<T, K> keyMapper) {
        return new SetMapCollector(keyMapper, Function.identity());
    }

    @Override
    public Supplier<SetMap<K, V>> supplier() {
        return SetMap::new;
    }

    @Override
    public BiConsumer<SetMap<K, V>, T> accumulator() {
        return (map, element) -> map.add(this.keyMapper.apply(element), this.valueMapper.apply(element));
    }

    @Override
    public BinaryOperator<SetMap<K, V>> combiner() {
        return (setMap1, setMap2) -> {
            setMap1.addAll(setMap2);
            return setMap1;
        };
    }

    @Override
    public Function<SetMap<K, V>, SetMap<K, V>> finisher() {
        return Function.identity();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.singleton(Collector.Characteristics.IDENTITY_FINISH);
    }
}

