/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.io.Serializable;
import java.util.Map;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class UnmodifiableMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> map;

    public UnmodifiableMap(Map<K, V> m) {
        if (m == null) {
            throw new IllegalArgumentException("Underlying map may not be null!");
        }
        this.map = m;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public UnmodifiableSet<K> keySet() {
        return new UnmodifiableSet<K>(this.map.keySet());
    }

    @Override
    public UnmodifiableCollection<V> values() {
        return new UnmodifiableCollection<V>(this.map.values());
    }

    @Override
    public UnmodifiableSet<Map.Entry<K, V>> entrySet() {
        return new UnmodifiableSet<Map.Entry<K, V>>(this.map.entrySet());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(K arg0, V arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object arg0) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnmodifiableMap) {
            return this.map.equals(((UnmodifiableMap)obj).map);
        }
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

