/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.color;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.conqat.lib.commons.color.IColor;
import org.conqat.lib.commons.string.StringUtils;

public enum ECCSMColor implements IColor
{
    LIGHT_BLUE(205, 222, 239),
    BLUE(99, 156, 206),
    PURPLE(50, 50, 102),
    DARK_BLUE(0, 117, 204),
    GREEN(102, 204, 102),
    YELLOW(251, 188, 5),
    RED(255, 51, 51),
    DARK_RED(204, 51, 51),
    LIGHT_GRAY(204, 204, 204),
    DARK_GRAY(102, 102, 102);

    private final int red;
    private final int green;
    private final int blue;
    private Color color;

    private ECCSMColor(int red, int green, int blue) {
        ECCSMColor.check(red);
        ECCSMColor.check(green);
        ECCSMColor.check(blue);
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    private static void check(int colorValue) {
        if (colorValue < 0 || colorValue > 255) {
            throw new IllegalArgumentException("Value must be between 0 and 255");
        }
    }

    @Override
    public String getHTMLColorCode() {
        return String.format("#%02X%02X%02X", this.red, this.green, this.blue);
    }

    @Override
    public Color getColor() {
        if (this.color == null) {
            this.color = new Color(this.red, this.green, this.blue);
        }
        return this.color;
    }

    public String toString() {
        return this.name() + "; " + this.getHTMLColorCode() + "; " + String.format("%03d, %03d, %03d", this.red, this.green, this.blue);
    }

    public static String getColorTable() {
        StringBuilder result = new StringBuilder();
        result.append("  HTML  |  r    g    b  | name");
        result.append(StringUtils.LINE_SEPARATOR);
        for (ECCSMColor color : ECCSMColor.values()) {
            result.append(color.getHTMLColorCode());
            result.append(" | ");
            result.append(String.format("%03d, %03d, %03d", color.red, color.green, color.blue));
            result.append(" | ");
            result.append(color.name());
            result.append(StringUtils.LINE_SEPARATOR);
        }
        return result.toString();
    }

    public static BufferedImage getColorChart(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graphics = image.createGraphics();
        float barHeight = (float)height / (float)ECCSMColor.values().length;
        boolean drawName = (float)graphics.getFontMetrics().getHeight() < barHeight;
        float y = 0.0f;
        for (ECCSMColor color : ECCSMColor.values()) {
            graphics.setColor(color.getColor());
            Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, y, width, barHeight);
            graphics.fill(rect);
            y += barHeight;
            if (!drawName) continue;
            graphics.setColor(Color.black);
            graphics.drawString(color.toString(), 5.0f, y - 3.0f);
        }
        return image;
    }
}

