/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.concurrent;

import org.conqat.lib.commons.assertion.CCSMAssert;

public abstract class RunnableWithAsyncResultBase<T, X extends Throwable>
implements Runnable {
    private T result;
    private Throwable caughtException = null;
    private boolean finished = false;

    @Override
    public final void run() {
        try {
            this.result = this.runWithResult();
        }
        catch (Throwable e) {
            this.caughtException = e;
        }
        this.finished = true;
    }

    public abstract T runWithResult() throws X;

    public boolean isFinished() {
        return this.finished;
    }

    public T getResult() throws X {
        CCSMAssert.isTrue(this.finished, "Can not query result before run() is finished!");
        if (this.caughtException instanceof RuntimeException) {
            throw (RuntimeException)this.caughtException;
        }
        if (this.caughtException instanceof Error) {
            throw (Error)this.caughtException;
        }
        if (this.caughtException != null) {
            throw this.caughtException;
        }
        return this.result;
    }
}

