/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.datamining;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.datamining.AssociationRule;
import org.conqat.lib.commons.datamining.FrequentItemSet;
import org.conqat.lib.commons.datamining.FrequentItemSetMiner;

public class AssociationRuleMiner<T> {
    private final float confidenceThreshold;
    private final FrequentItemSetMiner<T> itemSetMiner;

    public AssociationRuleMiner(float supportThreshold, float confidenceThreshold) {
        this.confidenceThreshold = confidenceThreshold;
        this.itemSetMiner = new FrequentItemSetMiner(supportThreshold);
    }

    public Set<AssociationRule<T>> mineAssociationRules(Set<Set<T>> baskets) {
        IdentityHashSet<AssociationRule<T>> result = new IdentityHashSet<AssociationRule<T>>();
        Set<FrequentItemSet<T>> frequentItemSets = this.itemSetMiner.mineFrequentItemSets(baskets);
        HashMap<Set<T>, Double> supportMap = new HashMap<Set<T>, Double>();
        for (FrequentItemSet<T> frequentItemset : frequentItemSets) {
            supportMap.put(frequentItemset.getItems(), frequentItemset.getSupport());
        }
        for (FrequentItemSet<T> frequentItemSet : frequentItemSets) {
            Set<T> items = frequentItemSet.getItems();
            if (items.size() <= 1) continue;
            for (T item : items) {
                HashSet<T> reducedItemSet = new HashSet<T>(items);
                reducedItemSet.remove(item);
                double confidence = frequentItemSet.getSupport() / (Double)supportMap.get(reducedItemSet);
                if (!(confidence >= (double)this.confidenceThreshold)) continue;
                result.add(new AssociationRule<T>(reducedItemSet, item, confidence));
            }
        }
        return result;
    }
}

