/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.datamining;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.datamining.FrequentItemSet;

public class FrequentItemSetMiner<T> {
    private final double supportThreshold;

    public FrequentItemSetMiner(double supportThreshold) {
        CCSMAssert.isTrue(supportThreshold >= 0.0 && supportThreshold <= 1.0, "supportThreshold must be in [0,1]");
        this.supportThreshold = supportThreshold;
    }

    public Set<FrequentItemSet<T>> mineFrequentItemSets(Set<Set<T>> baskets) {
        HashSet<FrequentItemSet<T>> result = new HashSet<FrequentItemSet<T>>();
        HashMap L_ks = new HashMap();
        HashSet<Set<T>> singletonItemSets = new HashSet<Set<T>>();
        L_ks.put(1, singletonItemSets);
        for (T item : CollectionUtils.unionSetAll(baskets)) {
            Set<T> singletonItemSet = Collections.singleton(item);
            double support = FrequentItemSetMiner.support(singletonItemSet, baskets);
            if (!(support >= this.supportThreshold)) continue;
            singletonItemSets.add(singletonItemSet);
            result.add(new FrequentItemSet<T>(singletonItemSet, support));
        }
        int k = 1;
        while (true) {
            Set<Set<T>> candidates = this.apriori_gen((Set)L_ks.get(k), k + 1);
            HashSet<Set<T>> L_k = new HashSet<Set<T>>();
            L_ks.put(k + 1, L_k);
            for (Set<T> candidate : candidates) {
                double support = FrequentItemSetMiner.support(candidate, baskets);
                if (!(support >= this.supportThreshold)) continue;
                L_k.add(candidate);
                result.add(new FrequentItemSet<T>(candidate, support));
            }
            if (L_k.isEmpty()) break;
            ++k;
        }
        return result;
    }

    private Set<Set<T>> apriori_gen(Set<Set<T>> L_k_1, int k) {
        HashSet<Set<T>> C_k = new HashSet<Set<T>>();
        ArrayList<Set<T>> asList = new ArrayList<Set<T>>(L_k_1);
        for (int i = 0; i < asList.size(); ++i) {
            block1: for (int j = i + 1; j < asList.size(); ++j) {
                HashSet union = CollectionUtils.unionSet((Collection)asList.get(i), (Collection)asList.get(j));
                if (union.size() != k) continue;
                for (Object item : union) {
                    HashSet check = new HashSet(union);
                    check.remove(item);
                    if (L_k_1.contains(check)) continue;
                    continue block1;
                }
                C_k.add(union);
            }
        }
        return C_k;
    }

    private static <T> double support(Set<T> itemSet, Set<Set<T>> baskets) {
        int count = 0;
        for (Set<T> basket : baskets) {
            if (!basket.containsAll(itemSet)) continue;
            ++count;
        }
        return (double)count / (double)baskets.size();
    }
}

