/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.datamining;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.datamining.IRecommenderUser;
import org.conqat.lib.commons.datamining.ShoppingBasketUser;

public class RecommenderRatingDatabase<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ListMap<IRecommenderUser, T> data = new ListMap();

    public UnmodifiableSet<IRecommenderUser> getUsers() {
        return CollectionUtils.asUnmodifiable(this.data.getKeys());
    }

    public void add(IRecommenderUser user, Set<T> likedItems) {
        this.data.addAll(user, likedItems);
    }

    public void remove(IRecommenderUser user) {
        this.data.removeCollection(user);
    }

    public Set<T> getLikedItems(IRecommenderUser user) {
        if (!this.data.containsCollection(user)) {
            throw new IllegalArgumentException("No such user: " + user);
        }
        return new HashSet(this.data.getCollection(user));
    }

    public static <T> RecommenderRatingDatabase<T> fromShoppingBaskets(Set<Set<T>> shoppingBaskets) {
        RecommenderRatingDatabase<T> ratingDatabase = new RecommenderRatingDatabase<T>();
        for (Set<T> basket : shoppingBaskets) {
            ratingDatabase.add(new ShoppingBasketUser<T>(basket), basket);
        }
        return ratingDatabase;
    }

    public String toString() {
        return this.data.toString();
    }
}

