/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.datamining;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.datamining.IRecommender;
import org.conqat.lib.commons.datamining.IRecommenderUser;
import org.conqat.lib.commons.datamining.Recommendation;
import org.conqat.lib.commons.datamining.RecommenderRatingDatabase;

public class TopNRecommender<T>
implements IRecommender<T> {
    private final Set<Recommendation<T>> recommendations = new HashSet<Recommendation<T>>();

    public TopNRecommender(RecommenderRatingDatabase<T> ratingDatabase, int numRecommendations) {
        CounterSet<T> occurences = new CounterSet<T>();
        for (IRecommenderUser user : ratingDatabase.getUsers()) {
            occurences.incAll(ratingDatabase.getLikedItems(user));
        }
        CCSMAssert.isTrue(occurences.getKeys().size() >= numRecommendations, "There have to be at least numRecommendation distinct items");
        List topItems = occurences.getKeysByValueDescending();
        for (int i = 0; i < numRecommendations; ++i) {
            this.recommendations.add(new Recommendation(topItems.get(i), 0.5));
        }
    }

    @Override
    public UnmodifiableSet<Recommendation<T>> recommend(IRecommenderUser user) {
        return CollectionUtils.asUnmodifiable(this.recommendations);
    }
}

