/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.factory.IFactory;

public class DateUtils {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long NANOS_PER_SECOND = 1000000000L;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int SECONDS_PER_DAY = 86400;
    private static final int DAYS_PER_YEAR = 365;
    private static final SimpleDateFormat MMM_DD_YYYY_HH_MM_FORMAT = new SimpleDateFormat("MMM dd yyyy HH:mm", Locale.ENGLISH);
    private static final SimpleDateFormat YYYY_MM_DD_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat EEE_MMM_DD_YYYY_FORMAT = new SimpleDateFormat("EEE MMM dd yyyy", Locale.ENGLISH);
    private static IFactory<Date, NeverThrownRuntimeException> nowFactory;

    public static Date getLatest(Collection<Date> dates) {
        if (dates.isEmpty()) {
            return null;
        }
        return Collections.max(dates);
    }

    public static Date getEarliest(Collection<Date> dates) {
        if (dates.isEmpty()) {
            return null;
        }
        return Collections.min(dates);
    }

    public static Date min(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        if (d1.compareTo(d2) < 0) {
            return d1;
        }
        return d2;
    }

    public static Date max(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        if (d2.compareTo(d1) > 0) {
            return d2;
        }
        return d1;
    }

    public static Date getDateBefore(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -days);
        return calendar.getTime();
    }

    public static synchronized Date getNow() {
        if (nowFactory == null) {
            String property = System.getProperty("org.conqat.lib.commons.date.now");
            if (property == null) {
                nowFactory = new CurrentDateFactory();
            } else {
                try {
                    nowFactory = new FixedDateFactory(new SimpleDateFormat("yyyyMMddHHmmss").parse(property));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Invalid date string provided via system property: " + property, e);
                }
            }
        }
        return nowFactory.create();
    }

    public static Date getNowWithoutTime() {
        return DateUtils.truncateToBeginOfDay(DateUtils.getNow());
    }

    public static synchronized IFactory<Date, NeverThrownRuntimeException> testcode_getNowFactory() {
        return nowFactory;
    }

    public static synchronized void testcode_setNowFactory(IFactory<Date, NeverThrownRuntimeException> nowFactory) {
        DateUtils.nowFactory = nowFactory;
    }

    public static synchronized void testcode_setFixedDate(Date date) {
        DateUtils.testcode_setNowFactory(new FixedDateFactory(date));
    }

    public static synchronized void testcode_resetNowFactory() {
        nowFactory = null;
    }

    public static Date incrementByOneDay(Date date) {
        return DateUtils.addDaysToDate(date, 1);
    }

    public static Date truncateToBeginOfDay(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = YYYY_MM_DD_FORMAT;
        synchronized (simpleDateFormat) {
            String normalized = YYYY_MM_DD_FORMAT.format(date);
            try {
                return YYYY_MM_DD_FORMAT.parse(normalized);
            }
            catch (ParseException e) {
                throw new AssertionError("ParseException.", e);
            }
        }
    }

    public static String formatTimestampToDateYYYYMMDD(long timestamp) {
        return DateUtils.formatTimestampToDate(timestamp, YYYY_MM_DD_FORMAT);
    }

    public static String formatTimestampToDateEEEMMMDDYYYY(long timestamp) {
        return DateUtils.formatTimestampToDate(timestamp, EEE_MMM_DD_YYYY_FORMAT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTimestampToDate(long timestamp, SimpleDateFormat format) {
        SimpleDateFormat simpleDateFormat = format;
        synchronized (simpleDateFormat) {
            return format.format(new Date(timestamp));
        }
    }

    public static long daysToMilliseconds(int days) {
        return (long)days * 86400000L;
    }

    public static long yearsToMilliseconds(int years) {
        return (long)years * DateUtils.daysToMilliseconds(365);
    }

    public static long hoursToMilliseconds(int hours) {
        return (long)hours * 3600000L;
    }

    public static long minutesToMilliseconds(int minutes) {
        return (long)minutes * 60000L;
    }

    public static long diff(Date earlier, Date later, TimeUnit timeUnit) {
        long diffInMillies = later.getTime() - earlier.getTime();
        return timeUnit.convert(diffInMillies, TimeUnit.MILLISECONDS);
    }

    public static long diffDays(Date earlier, Date later) {
        return DateUtils.diff(earlier, later, TimeUnit.DAYS);
    }

    public static Date addDaysToDate(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, days);
        return calendar.getTime();
    }

    public static Date subtractDaysFromDate(Date date, int days) {
        return DateUtils.addDaysToDate(date, -days);
    }

    public static List<Date> getDatePointsInTimespan(Date startDate, Date endDate, int daysBetweenDatePoints, boolean includeEndDate) {
        CCSMAssert.isNotNull(startDate);
        CCSMAssert.isNotNull(endDate);
        CCSMAssert.isFalse(startDate.after(endDate), "startDate is after endDate");
        CCSMAssert.isTrue(daysBetweenDatePoints > 0, "daysBetweenDatePoints must be > 0");
        ArrayList<Date> result = new ArrayList<Date>();
        result.add(startDate);
        Date currentDate = startDate;
        while ((currentDate = DateUtils.addDaysToDate(currentDate, daysBetweenDatePoints)).before(endDate)) {
            result.add(currentDate);
        }
        if (includeEndDate) {
            result.add(endDate);
        }
        return result;
    }

    public static Long getTimeOfDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    public static Date createDate(int day, int month, int year) {
        if (month == 12) {
            throw new IllegalArgumentException("month is zero-based, use the Calendar instances");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day);
        return DateUtils.truncateToBeginOfDay(calendar.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUiFormattedDateString(long milliseconds) {
        Date date = new Date(milliseconds);
        SimpleDateFormat simpleDateFormat = MMM_DD_YYYY_HH_MM_FORMAT;
        synchronized (simpleDateFormat) {
            return MMM_DD_YYYY_HH_MM_FORMAT.format(date);
        }
    }

    public static String formatDate(long timestamp, String pattern) {
        return DateUtils.formatDateInTimezone(timestamp, pattern, ZoneId.systemDefault());
    }

    public static String formatDateInTimezone(long timestamp, String pattern, ZoneId zoneId) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.ENGLISH);
        return localDateTime.format(formatter);
    }

    public static String formatDurationHumanReadable(Duration duration) {
        long milliseconds = duration.toMillis() % 1000L;
        long seconds = duration.toMillis() / 1000L % 60L;
        long minutes = duration.toMillis() / 1000L / 60L % 60L;
        long hours = duration.toMillis() / 1000L / 60L / 60L;
        StringBuilder builder = new StringBuilder();
        if (hours > 0L) {
            builder.append(hours).append("h ");
        }
        if (hours > 0L || minutes > 0L) {
            builder.append(minutes).append("min ");
        }
        if (hours > 0L || minutes > 0L || seconds > 0L) {
            builder.append(seconds).append("s ");
        }
        builder.append(milliseconds).append("ms");
        return builder.toString();
    }

    public static double nanosToSeconds(long nanos) {
        return (double)nanos / 1.0E9;
    }

    public static ZonedDateTime createZonedDateTimeForTimestamp(long timestamp) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
    }

    public static long toTimestamp(LocalDate date) {
        return date.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long toTimestamp(LocalDateTime date) {
        return date.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static class CurrentDateFactory
    implements IFactory<Date, NeverThrownRuntimeException> {
        @Override
        public Date create() throws NeverThrownRuntimeException {
            return new Date();
        }
    }

    public static class FixedDateFactory
    implements IFactory<Date, NeverThrownRuntimeException> {
        private final Date now;

        public FixedDateFactory(Date now) {
            this.now = now;
        }

        @Override
        public Date create() throws NeverThrownRuntimeException {
            return (Date)this.now.clone();
        }
    }
}

