/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.diff;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

@ExportToTypeScript
public class DiffDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="leftChangeLines")
    private final List<Integer> leftChangeLines = new ArrayList<Integer>();
    @JsonProperty(value="rightChangeLines")
    private final List<Integer> rightChangeLines = new ArrayList<Integer>();
    @JsonProperty(value="leftChangeRegions")
    private final List<Integer> leftChangeRegions = new ArrayList<Integer>();
    @JsonProperty(value="rightChangeRegions")
    private final List<Integer> rightChangeRegions = new ArrayList<Integer>();

    @JsonCreator
    public DiffDescription() {
        this("");
    }

    public DiffDescription(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addLineRegion(int leftFirstLine, int leftEndLine, int rightFirstLine, int rightEndLine) {
        DiffDescription.addLineRegion(leftFirstLine, leftEndLine, this.leftChangeLines);
        DiffDescription.addLineRegion(rightFirstLine, rightEndLine, this.rightChangeLines);
    }

    private static void addLineRegion(int firstLine, int endLine, List<Integer> changeLines) {
        CCSMAssert.isTrue(firstLine >= 0, "May only insert positive lines!");
        CCSMAssert.isTrue(firstLine <= endLine, "End must not be before start!");
        CCSMAssert.isTrue(changeLines.isEmpty() || CollectionUtils.getLast(changeLines) - 1 <= firstLine, "Must insert in ascending order!");
        changeLines.add(firstLine);
        changeLines.add(endLine);
    }

    public void addLeftChange(int startOffset, int endOffset) {
        DiffDescription.addChange(startOffset, endOffset, this.leftChangeRegions);
    }

    public void addRightChange(int startOffset, int endOffset) {
        DiffDescription.addChange(startOffset, endOffset, this.rightChangeRegions);
    }

    private static void addChange(int startOffset, int endOffset, List<Integer> changeTokens) {
        if (!changeTokens.isEmpty() && startOffset <= CollectionUtils.getLast(changeTokens)) {
            changeTokens.set(changeTokens.size() - 1, endOffset);
        } else {
            changeTokens.add(startOffset);
            changeTokens.add(endOffset);
        }
    }

    public UnmodifiableList<Integer> getLeftChangeRegions() {
        return CollectionUtils.asUnmodifiable(this.leftChangeRegions);
    }

    public UnmodifiableList<Integer> getRightChangeRegions() {
        return CollectionUtils.asUnmodifiable(this.rightChangeRegions);
    }

    public void addLeftChangeRegions(UnmodifiableList<Integer> leftChangeRegions) {
        this.leftChangeRegions.addAll(leftChangeRegions);
    }

    public void addRightChangeRegions(UnmodifiableList<Integer> rightChangeRegions) {
        this.rightChangeRegions.addAll(rightChangeRegions);
    }

    public UnmodifiableList<Integer> getLeftChangeLines() {
        return CollectionUtils.asUnmodifiable(this.leftChangeLines);
    }

    public UnmodifiableList<Integer> getRightChangeLines() {
        return CollectionUtils.asUnmodifiable(this.rightChangeLines);
    }
}

