/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.digest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.error.EnvironmentError;
import org.conqat.lib.commons.string.StringUtils;

public class Digester {
    private static final ThreadLocal<MessageDigest> MD5_DIGESTERS = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            return Digester.getMD5();
        }
    };
    private static final ThreadLocal<MessageDigest> SHA256_DIGESTERS = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            return Digester.getSHA256();
        }
    };

    public static String createMD5Digest(String base) {
        return Digester.createMD5Digest(base.getBytes());
    }

    public static String createMD5Digest(byte[] data) {
        MessageDigest digester = MD5_DIGESTERS.get();
        digester.reset();
        return StringUtils.encodeAsHex(digester.digest(data));
    }

    public static String createSHA256Digest(String base) {
        return Digester.createSHA256Digest(base.getBytes());
    }

    public static String createSHA256Digest(byte[] data) {
        MessageDigest digester = SHA256_DIGESTERS.get();
        digester.reset();
        return StringUtils.encodeAsHex(digester.digest(data));
    }

    public static String createMD5Digest(Collection<String> bases) {
        ArrayList<String> sortedBases = CollectionUtils.sort(bases);
        return Digester.createMD5Digest(StringUtils.concat(sortedBases, ""));
    }

    public static byte[] createBinaryMD5Digest(byte[] data) {
        MessageDigest digester = MD5_DIGESTERS.get();
        digester.reset();
        return digester.digest(data);
    }

    public static MessageDigest getMD5() {
        return Digester.getDigester("MD5");
    }

    public static MessageDigest getSHA1() {
        return Digester.getDigester("SHA-1");
    }

    public static MessageDigest getSHA256() {
        return Digester.getDigester("SHA-256");
    }

    private static MessageDigest getDigester(String algorithmName) {
        try {
            return MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EnvironmentError("No " + algorithmName + " algorithm found. Please check your JRE installation", e);
        }
    }
}

