/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.enums;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

public class EnumUtils {
    public static <T extends Enum<T>> T valueOf(Class<T> enumType, String constantName) {
        try {
            T constant = Enum.valueOf(enumType, constantName);
            return constant;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static <T extends Enum<T>> EnumSet<T> valuesOf(Class<T> enumType, Collection<String> constantNames) {
        EnumSet<T> result = EnumSet.noneOf(enumType);
        for (String constant : constantNames) {
            result.add(EnumUtils.valueOf(enumType, constant));
        }
        return result;
    }

    public static <T extends Enum<T>> T valueOfIgnoreCase(Class<T> enumType, String constantName) {
        Enum[] constants = (Enum[])enumType.getEnumConstants();
        CCSMAssert.isNotNull(constants);
        for (Enum constant : constants) {
            if (!constant.name().equalsIgnoreCase(constantName)) continue;
            return (T)constant;
        }
        return null;
    }

    public static <T extends Enum<T>> String[] names(Class<T> enumType) {
        Enum[] constants = (Enum[])enumType.getEnumConstants();
        CCSMAssert.isNotNull(constants);
        String[] result = new String[constants.length];
        for (int i = 0; i < constants.length; ++i) {
            result[i] = constants[i].name();
        }
        return result;
    }

    @SafeVarargs
    public static <T extends Enum<T>> EnumSet<T> mergeSets(EnumSet<T> set, T ... values) {
        Object newSet = set.clone();
        ((AbstractCollection)newSet).addAll(Arrays.asList(values));
        return newSet;
    }

    @SafeVarargs
    public static <T extends Enum<T>> EnumSet<T> copyOfExcept(EnumSet<T> set, T ... values) {
        EnumSet<T> newSet = EnumSet.copyOf(set);
        CollectionUtils.removeAll(newSet, Arrays.asList(values));
        return newSet;
    }
}

