/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

public class AntPatternUtils {
    public static Pattern convertPattern(String antPattern, boolean caseSensitive) throws PatternSyntaxException {
        antPattern = AntPatternUtils.normalizePattern(antPattern);
        boolean addTrailAll = false;
        if (antPattern.endsWith("/**")) {
            addTrailAll = true;
            antPattern = StringUtils.stripSuffix(antPattern, "/**");
        }
        StringBuilder patternBuilder = new StringBuilder();
        AntPatternUtils.convertPlainPattern(antPattern, patternBuilder);
        if (addTrailAll) {
            patternBuilder.append("(/.*)?");
        }
        return AntPatternUtils.compileRegex(patternBuilder.toString(), antPattern, caseSensitive);
    }

    private static Pattern compileRegex(String regex, String antPattern, boolean caseSensitive) {
        try {
            return Pattern.compile(regex, AntPatternUtils.determineRegexFlags(caseSensitive));
        }
        catch (PatternSyntaxException e) {
            throw new PatternSyntaxException("Error compiling ANT pattern '" + antPattern + "' to regular expression. " + e.getDescription(), e.getPattern(), e.getIndex());
        }
    }

    private static int determineRegexFlags(boolean caseSensitive) {
        int flags = 32;
        if (!caseSensitive) {
            flags |= 2;
        }
        return flags;
    }

    private static String normalizePattern(String antPattern) {
        if ((antPattern = FileSystemUtils.normalizeSeparators(antPattern)).endsWith("/")) {
            antPattern = antPattern + "**";
        }
        return antPattern;
    }

    private static void convertPlainPattern(String antPattern, StringBuilder patternBuilder) {
        for (int i = 0; i < antPattern.length(); ++i) {
            char c = antPattern.charAt(i);
            if (c == '?') {
                patternBuilder.append("[^/]");
                continue;
            }
            if (c != '*') {
                patternBuilder.append(Pattern.quote(Character.toString(c)));
                continue;
            }
            i = AntPatternUtils.convertStarSequence(antPattern, patternBuilder, i);
        }
    }

    private static int convertStarSequence(String antPattern, StringBuilder patternBuilder, int index) {
        boolean doubleStar = AntPatternUtils.isCharAt(antPattern, index + 1, '*');
        if (doubleStar) {
            boolean doubleStarSlash = AntPatternUtils.isCharAt(antPattern, index + 2, '/');
            if (doubleStarSlash) {
                patternBuilder.append("(.*/)?");
                return index + 2;
            }
            boolean doubleStarDot = AntPatternUtils.isCharAtBeforeSlashOrEnd(antPattern, index + 2, '.');
            if (doubleStarDot) {
                patternBuilder.append("(.*/)?[^/.]*[.]?");
                return index + 2;
            }
            patternBuilder.append(".*");
            return index + 1;
        }
        boolean starDot = AntPatternUtils.isCharAtBeforeSlashOrEnd(antPattern, index + 1, '.');
        if (starDot) {
            patternBuilder.append("[^/.]*[.]?");
            return index + 1;
        }
        patternBuilder.append("[^/]*");
        return index;
    }

    private static boolean isCharAtBeforeSlashOrEnd(String s, int position, char character) {
        return AntPatternUtils.isCharAt(s, position, character) && (position + 1 == s.length() || AntPatternUtils.isCharAt(s, position + 1, '/'));
    }

    private static boolean isCharAt(String s, int position, char character) {
        return position < s.length() && s.charAt(position) == character;
    }

    public static Pattern convertPatternSafe(String antPattern, boolean caseSensitive) throws ConQATException {
        try {
            return AntPatternUtils.convertPattern(antPattern, caseSensitive);
        }
        catch (PatternSyntaxException e) {
            throw new ConQATException(e.getMessage(), e);
        }
    }
}

