/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.io;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.concurrent.InterruptTimerTask;
import org.conqat.lib.commons.io.StreamReaderThread;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.system.SystemUtils;

public class ProcessUtils {
    public static final String MONO_COMMAND = "mono";
    public static Charset CONSOLE_CHARSET = StandardCharsets.UTF_8;

    public static ProcessBuilder createDotNetProcessBuilder(String ... arguments) {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (!SystemUtils.isWindows()) {
            builder.command().add(MONO_COMMAND);
        }
        builder.command().addAll(Arrays.asList(arguments));
        return builder;
    }

    public static ExecutionResult executeDotNet(String[] completeArguments) throws IOException {
        return ProcessUtils.execute(ProcessUtils.createDotNetProcessBuilder(completeArguments));
    }

    public static ExecutionResult execute(String[] completeArguments) throws IOException {
        return ProcessUtils.execute(completeArguments, null);
    }

    public static ExecutionResult execute(String[] completeArguments, String input) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(completeArguments);
        return ProcessUtils.execute(builder, input);
    }

    public static ExecutionResult execute(ProcessBuilder builder) throws IOException {
        return ProcessUtils.execute(builder, null);
    }

    public static ExecutionResult execute(ProcessBuilder builder, String input) throws IOException {
        return ProcessUtils.execute(builder, input, -1);
    }

    public static ExecutionResult execute(ProcessBuilder builder, String input, int timeOut) throws IOException {
        return ProcessUtils.execute(builder, input, timeOut, true);
    }

    public static ExecutionResult execute(ProcessBuilder builder, String input, int timeOut, boolean collectOutputStreamContent) throws IOException {
        Process process = builder.start();
        StreamReaderThread stderrReader = new StreamReaderThread(process.getErrorStream(), CONSOLE_CHARSET, collectOutputStreamContent);
        StreamReaderThread stdoutReader = new StreamReaderThread(process.getInputStream(), CONSOLE_CHARSET, collectOutputStreamContent);
        if (input != null) {
            OutputStreamWriter stdIn = new OutputStreamWriter(process.getOutputStream());
            stdIn.write(input);
            ((Writer)stdIn).close();
        }
        boolean normalTermination = ProcessUtils.waitForProcess(process, timeOut);
        int exitValue = -1;
        if (normalTermination) {
            exitValue = process.exitValue();
        }
        try {
            stderrReader.join();
            stdoutReader.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new ExecutionResult(stdoutReader.getContent(), stderrReader.getContent(), exitValue, normalTermination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitForProcess(Process process, int maxRuntimeSeconds) {
        Timer timer = new Timer(true);
        if (maxRuntimeSeconds > 0) {
            timer.schedule((TimerTask)new InterruptTimerTask(Thread.currentThread()), maxRuntimeSeconds * 1000);
        }
        try {
            process.waitFor();
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            process.destroy();
            boolean bl = false;
            return bl;
        }
        finally {
            timer.cancel();
            Thread.interrupted();
        }
    }

    public static <T extends Exception> ExecutionResult executeOrThrow(ProcessBuilder builder, String input, int timeout, BiFunction<String, Throwable, T> exceptionConstructor) throws T {
        String commandString = StringUtils.concat(builder.command(), " ");
        try {
            ExecutionResult result = ProcessUtils.execute(builder, input, timeout);
            if (!result.isNormalTermination()) {
                throw (Exception)exceptionConstructor.apply("Process " + commandString + " timed out.", null);
            }
            if (result.getReturnCode() != 0) {
                throw (Exception)exceptionConstructor.apply("Process " + commandString + " failed with non-zero exit code " + result.getReturnCode() + ". Standard output: '" + result.getStdout() + "', Error output: '" + result.getStderr() + "'", null);
            }
            return result;
        }
        catch (IOException e) {
            throw (Exception)exceptionConstructor.apply("Failed to execute " + commandString, e);
        }
    }

    static {
        if (SystemUtils.isWindows()) {
            try {
                ExecutionResult result = ProcessUtils.execute(new String[]{"chcp.com"});
                Matcher matcher = Pattern.compile("\\d+").matcher(result.getStdout());
                if (matcher.find()) {
                    CONSOLE_CHARSET = Charset.forName("Cp" + matcher.group());
                }
            }
            catch (IOException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }

    public static class ExecutionResult {
        private final String stdout;
        private final String stderr;
        private final int returnCode;
        private final boolean normalTermination;

        private ExecutionResult(String stdout, String stderr, int returnCode, boolean normalTermination) {
            this.stdout = stdout;
            this.stderr = stderr;
            this.returnCode = returnCode;
            this.normalTermination = normalTermination;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }

        public int getReturnCode() {
            return this.returnCode;
        }

        public boolean isNormalTermination() {
            return this.normalTermination;
        }
    }
}

