/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class SelfDeletingTempDirectory
implements AutoCloseable {
    private final File directory;

    public File getDirectory() {
        return this.directory;
    }

    public SelfDeletingTempDirectory(String prefix) throws IOException {
        this.directory = Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
    }

    @Override
    public void close() {
        FileSystemUtils.deleteRecursively(this.directory);
        if (this.directory.exists()) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> FileSystemUtils.deleteRecursively(this.directory)));
        }
    }
}

