/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.markup;

import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public class MarkupUtils {
    private static final PairList<String, String> ESCAPING_RULES = new PairList();

    public static String escapeMarkdownRelevantSymbols(String s) {
        for (Pair<String, String> pair : ESCAPING_RULES) {
            s = s.replaceAll((String)pair.getFirst(), (String)pair.getSecond());
        }
        return s;
    }

    public static String unescapeMarkdownRelevantSymbols(String s) {
        for (Pair<String, String> pair : ESCAPING_RULES.reverse()) {
            s = s.replaceAll((String)pair.getSecond(), (String)pair.getFirst());
        }
        return s;
    }

    public static String trimLines(String extractedText) {
        StringBuilder reformattedText = new StringBuilder();
        String[] lines = StringUtils.splitLines(extractedText);
        boolean hasOpenedCodeBlock = false;
        for (String line : lines) {
            if (hasOpenedCodeBlock) {
                reformattedText.append(line);
            } else {
                reformattedText.append(line.trim());
            }
            reformattedText.append("\n");
            hasOpenedCodeBlock &= !line.contains("</pre>");
            hasOpenedCodeBlock |= line.lastIndexOf("</pre>") < line.lastIndexOf("<pre>");
        }
        return reformattedText.toString();
    }

    public static String formatAsSourceCode(String sourceCodeText) {
        int numberOfEnclosingBackticks = MarkupUtils.findMaxNumberOfBackticks(sourceCodeText) + 1;
        String enclosingBackticks = StringUtils.repeat("`", numberOfEnclosingBackticks);
        StringBuilder enclosedText = new StringBuilder(enclosingBackticks);
        if (sourceCodeText.startsWith("`")) {
            enclosedText.append(" ");
        }
        enclosedText.append(sourceCodeText);
        if (sourceCodeText.endsWith("`")) {
            enclosedText.append(" ");
        }
        enclosedText.append(enclosingBackticks);
        return enclosedText.toString();
    }

    private static int findMaxNumberOfBackticks(String sourceCodeText) {
        int maxNumberOfBackticks = 0;
        int currentNumberOfBackticks = 0;
        for (char c : sourceCodeText.toCharArray()) {
            currentNumberOfBackticks = c == '`' ? ++currentNumberOfBackticks : 0;
            maxNumberOfBackticks = Math.max(maxNumberOfBackticks, currentNumberOfBackticks);
        }
        return maxNumberOfBackticks;
    }

    static {
        ESCAPING_RULES.add("#", "&#35;");
        ESCAPING_RULES.add("\\*", "&#42;");
        ESCAPING_RULES.add("_", "&#95;");
        ESCAPING_RULES.add("~", "&#126;");
        ESCAPING_RULES.add("\\[", "&#91;");
        ESCAPING_RULES.add("]", "&#93;");
        ESCAPING_RULES.add("!", "&#33;");
        ESCAPING_RULES.add("`", "&#96;");
        ESCAPING_RULES.add("\\n", "&nbsp;");
        ESCAPING_RULES.add("//", "//<span></span>");
        ESCAPING_RULES.add("www", "www<span></span>");
    }
}

