/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.options;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.options.AOptionComparator;
import org.conqat.lib.commons.options.CommandLineTokenStream;
import org.conqat.lib.commons.options.Option;
import org.conqat.lib.commons.options.OptionApplicator;
import org.conqat.lib.commons.options.OptionException;
import org.conqat.lib.commons.options.OptionRegistry;
import org.conqat.lib.commons.reflect.TypeConversionException;
import org.conqat.lib.commons.string.StringUtils;

public class CommandLine {
    private final OptionRegistry registry;

    public CommandLine(OptionRegistry registry) {
        this.registry = registry;
    }

    public String[] parse(String[] args) throws OptionException {
        return this.parse(new CommandLineTokenStream(args));
    }

    public String[] parse(CommandLineTokenStream ts) throws OptionException {
        ArrayList<String> remainingArgs = new ArrayList<String>();
        while (ts.hasNext()) {
            OptionApplicator applicator;
            if (ts.nextIsSeparator()) {
                ts.next();
                while (ts.hasNext()) {
                    remainingArgs.add(ts.next());
                }
                continue;
            }
            if (ts.nextIsLongOption()) {
                String name = ts.nextLongOption();
                applicator = this.registry.getLongOption(name);
                CommandLine.applyOption(applicator, CommandLine.formatLongOption(name), ts);
                continue;
            }
            if (ts.nextIsShortOption()) {
                char name = ts.nextShortOption();
                applicator = this.registry.getShortOption(name);
                CommandLine.applyOption(applicator, CommandLine.formatShortOption(name), ts);
                continue;
            }
            if (ts.nextIsFileArgument()) {
                remainingArgs.add(ts.next());
                continue;
            }
            throw new OptionException("Unexpected command line argument: " + ts.next());
        }
        return CollectionUtils.toArray(remainingArgs, String.class);
    }

    private static void applyOption(OptionApplicator applicator, String optionName, CommandLineTokenStream ts) throws OptionException {
        if (applicator == null) {
            throw new OptionException("Unknown option: " + optionName);
        }
        if (applicator.requiresParameter()) {
            if (!ts.nextIsParameter()) {
                throw new OptionException("Missing argument for option: " + optionName);
            }
            do {
                String parameter = ts.next();
                try {
                    applicator.applyOption(parameter);
                }
                catch (TypeConversionException e) {
                    throw new OptionException("Parameter " + parameter + " for option " + optionName + " is not of required type!");
                }
            } while (applicator.isGreedy() && ts.hasNext() && !ts.nextIsLongOption() && !ts.nextIsShortOption());
        } else {
            applicator.applyOption();
        }
    }

    public void printUsage(PrintWriter pw) {
        this.printUsage(pw, 20, 80);
    }

    public void printUsage(PrintWriter pw, int firstCol, int width) {
        ArrayList<Option> sortedOptions = new ArrayList<Option>(this.registry.getAllOptions());
        Collections.sort(sortedOptions, new AOptionComparator());
        for (Option option : sortedOptions) {
            CommandLine.printOption(option, pw, firstCol, width);
        }
        pw.flush();
    }

    private static void printOption(Option option, PrintWriter pw, int firstCol, int width) {
        String[] words;
        String names = CommandLine.formatNames(option);
        pw.print(names);
        int pos = names.length();
        if (pos > firstCol) {
            pos = width + 1;
        } else {
            pw.print(StringUtils.fillString(firstCol - pos, ' '));
        }
        String indent = StringUtils.fillString(firstCol, ' ');
        for (String word : words = option.description().split("\\s+")) {
            if (pos + 1 + word.length() > width) {
                pw.println();
                pw.print(indent);
                pos = firstCol;
            }
            pw.print(' ');
            pw.print(word);
            pos += 1 + word.length();
        }
        pw.println();
    }

    private static String formatNames(Option option) {
        String names = "  ";
        if (option.shortName() == '\u0000') {
            names = names + StringUtils.fillString(2 + CommandLine.formatShortOption('x').length(), ' ');
        } else {
            names = names + CommandLine.formatShortOption(option.shortName());
            if (option.longName().length() > 0) {
                names = names + ", ";
            }
        }
        if (option.longName().length() > 0) {
            names = names + CommandLine.formatLongOption(option.longName());
        }
        return names;
    }

    private static String formatLongOption(String name) {
        return "--" + name;
    }

    private static String formatShortOption(char name) {
        return "-" + name;
    }
}

