/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.options;

import java.io.PrintWriter;
import java.util.function.Supplier;
import org.conqat.lib.commons.options.CommandLine;
import org.conqat.lib.commons.options.Option;
import org.conqat.lib.commons.options.OptionException;
import org.conqat.lib.commons.options.OptionRegistry;
import org.conqat.lib.commons.string.StringUtils;

public abstract class CommandLineBase<E extends Exception> {
    private CommandLine cmdLine;

    @Option(shortName=104, longName="help", description="print this usage message")
    public void printUsageAndExit() {
        this.cmdLine.printUsage(new PrintWriter(System.err));
        System.exit(1);
    }

    protected void initFromCommandLine(String[] args) {
        this.cmdLine = new CommandLine(new OptionRegistry(this));
        try {
            String[] leftOvers = this.cmdLine.parse(args);
            this.handleLeftOvers(leftOvers);
        }
        catch (OptionException e) {
            CommandLineBase.abort("Incorrect options: " + e.getMessage());
        }
    }

    protected void handleLeftOvers(String[] leftOvers) {
        if (leftOvers.length > 0) {
            System.err.println("Unsupported trailing options: " + StringUtils.concat((Object[])leftOvers, " "));
            this.printUsageAndExit();
        }
    }

    protected static void abort(String message) {
        System.err.println(message);
        System.exit(-1);
    }

    protected abstract void run() throws E;

    protected static <E extends Exception> void execute(Supplier<CommandLineBase<E>> constructor, String[] args) throws E {
        CommandLineBase<E> tool = constructor.get();
        tool.initFromCommandLine(args);
        tool.run();
    }

    protected static void exitIfFalse(boolean condition, String message) {
        CommandLineBase.exitIfTrue(!condition, message);
    }

    protected static void exitIfTrue(boolean condition, String message) {
        if (condition) {
            CommandLineBase.exitWithMessage(message, null);
        }
    }

    protected static void exitWithMessage(String message, Exception e) {
        System.err.println(message);
        if (e != null) {
            e.printStackTrace();
        }
        System.exit(1);
    }
}

