/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.predicate;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public class OrPredicate<T>
implements Predicate<T> {
    private final List<Predicate<T>> innerPredicates;

    @SafeVarargs
    public OrPredicate(Predicate<T> ... innerPredicates) {
        this.innerPredicates = Arrays.asList(innerPredicates);
    }

    @Override
    public boolean test(T element) {
        for (Predicate<T> inner : this.innerPredicates) {
            if (!inner.test(element)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> OrPredicate<T> create(Predicate<T> ... innerPredicates) {
        return new OrPredicate<T>(innerPredicates);
    }
}

