/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.reflect;

import java.util.HashSet;
import java.util.Set;
import org.conqat.lib.commons.reflect.ReflectionUtils;

public final class ClassType {
    private Class<?> baseClass = Object.class;
    private Set<Class<?>> interfaces = new HashSet();

    public ClassType() {
    }

    public ClassType(Class<?> clazz) {
        if (clazz.isInterface()) {
            this.interfaces.add(clazz);
            this.normalizeInterfaces();
        } else {
            this.baseClass = ReflectionUtils.resolvePrimitiveClass(clazz);
        }
    }

    private void normalizeInterfaces() {
        Set<Class<?>> oldInterfaces = this.interfaces;
        this.interfaces = new HashSet();
        for (Class<?> iface : oldInterfaces) {
            if (iface.isAssignableFrom(this.baseClass)) continue;
            boolean isCovered = false;
            for (Class<?> otherIface : oldInterfaces) {
                if (iface == otherIface || !iface.isAssignableFrom(otherIface)) continue;
                isCovered = true;
                break;
            }
            if (isCovered) continue;
            this.interfaces.add(iface);
        }
    }

    public Class<?> getBaseClass() {
        return this.baseClass;
    }

    public boolean hasInterfaces() {
        return !this.interfaces.isEmpty();
    }

    public String toString() {
        if (this.interfaces.size() == 1 && this.baseClass.equals(Object.class)) {
            return this.interfaces.iterator().next().getName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseClass.getName());
        if (!this.interfaces.isEmpty()) {
            String sep = " ";
            sb.append(" implements");
            for (Class<?> iface : this.interfaces) {
                sb.append(sep);
                sep = ", ";
                sb.append(iface.getName());
            }
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassType)) {
            return false;
        }
        ClassType ct = (ClassType)obj;
        if (!ct.baseClass.equals(this.baseClass)) {
            return false;
        }
        if (ct.interfaces.size() != this.interfaces.size()) {
            return false;
        }
        for (Class<?> iface : ct.interfaces) {
            if (this.interfaces.contains(iface)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (Class<?> iface : this.interfaces) {
            result *= iface.hashCode();
        }
        return 13 * result * this.baseClass.hashCode();
    }
}

