/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public final class FormalParameter {
    private final Method method;
    private final int position;

    FormalParameter(Method method, int position) {
        this.method = method;
        this.position = position;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getType() {
        return this.method.getParameterTypes()[this.position];
    }

    public Type getGenericType() {
        return this.method.getGenericParameterTypes()[this.position];
    }

    public Annotation[] getAnnotations() {
        Annotation[][] annotations = this.method.getParameterAnnotations();
        return annotations[this.position];
    }

    public int getPosition() {
        return this.position;
    }

    public int hashCode() {
        return this.method.hashCode() ^ this.position + 1;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException();
        }
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotation.annotationType().equals(annotationClass)) continue;
            return (A)annotation;
        }
        return null;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException();
        }
        return this.getAnnotation(annotationClass) != null;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FormalParameter)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        FormalParameter otherFormalParameter = (FormalParameter)object;
        return this.method.equals(otherFormalParameter.method) && this.position == otherFormalParameter.position;
    }

    public String toString() {
        return "Formal parameter #" + this.position + " of method '" + this.method.getName() + "' (type: '" + this.getType().getName() + "')";
    }
}

