/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class GenericTypeResolver {
    private final Map<TypeVariable<?>, Class<?>> parameterLookup = new HashMap();

    public GenericTypeResolver(Class<?> clazz) {
        if (clazz.getTypeParameters().length != 0) {
            throw new IllegalArgumentException("This only works for non-generic classes!");
        }
        this.fillParamMap(clazz);
    }

    public GenericTypeResolver(Field field, GenericTypeResolver parentResolver) {
        this.parameterLookup.putAll(parentResolver.parameterLookup);
        this.fillInParameters(field.getType(), field.getGenericType());
        this.fillParamMap(field.getType());
    }

    private void fillParamMap(Class<?> clazz) {
        Type[] genericInterfaces;
        Class<?>[] interfaces;
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            Type superType = clazz.getGenericSuperclass();
            this.fillInParameters(superClass, superType);
            this.fillParamMap(superClass);
        }
        GenericTypeResolver.check((interfaces = clazz.getInterfaces()).length == (genericInterfaces = clazz.getGenericInterfaces()).length, "Interface lists should be equally long!");
        for (int i = 0; i < interfaces.length; ++i) {
            this.fillInParameters(interfaces[i], genericInterfaces[i]);
            this.fillParamMap(interfaces[i]);
        }
    }

    private void fillInParameters(Class<?> clazz, Type type) {
        if (type instanceof ParameterizedType) {
            TypeVariable<Class<?>>[] typeParameters;
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            GenericTypeResolver.check(actualTypeArguments.length == (typeParameters = clazz.getTypeParameters()).length, "Type parameters and actual arguments should be equally long!");
            for (int i = 0; i < typeParameters.length; ++i) {
                this.parameterLookup.put(typeParameters[i], this.resolveGenericType(actualTypeArguments[i]));
            }
        }
    }

    public Class<?> resolveGenericType(Type genericType) {
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        if (genericType instanceof TypeVariable) {
            GenericTypeResolver.check(this.parameterLookup.containsKey(genericType), "All generic parameters should be bound.");
            return this.parameterLookup.get(genericType);
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            return (Class)pt.getRawType();
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)genericType;
            return Array.newInstance(this.resolveGenericType(gat.getGenericComponentType()), 0).getClass();
        }
        GenericTypeResolver.check(false, "Generic types should be either concrete classes, type variables, or parametrized types: " + genericType.getClass());
        return null;
    }

    private static void check(boolean assumedCondition, String errorMessage) {
        CCSMAssert.isTrue(assumedCondition, errorMessage);
    }
}

