/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.reflect;

import java.awt.Color;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.color.ColorUtils;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.reflect.EJavaPrimitive;
import org.conqat.lib.commons.reflect.FormalParameter;
import org.conqat.lib.commons.reflect.GenericTypeResolver;
import org.conqat.lib.commons.reflect.TypeConversionException;
import org.conqat.lib.commons.version.Version;

public class ReflectionUtils {
    public static <T> T convertString(String value, Class<T> targetType) throws TypeConversionException {
        if (value == null) {
            if (String.class.equals(targetType)) {
                return (T)"";
            }
            throw new TypeConversionException("Null value can't be converted to type '" + targetType.getName() + "'.");
        }
        if (targetType.equals(Object.class) || targetType.equals(String.class)) {
            return (T)value;
        }
        if (targetType.isPrimitive() || EJavaPrimitive.isWrapperType(targetType)) {
            return ReflectionUtils.convertPrimitive(value, targetType);
        }
        if (targetType.isEnum()) {
            T result = EnumUtils.valueOfIgnoreCase(targetType, value);
            if (result == null) {
                throw new TypeConversionException("'" + value + "' is no valid value for enum " + targetType.getName());
            }
            return result;
        }
        if (targetType.equals(Color.class)) {
            Color result = ColorUtils.fromString(value);
            if (result == null) {
                throw new TypeConversionException("'" + value + "' is not a valid color!");
            }
            return (T)result;
        }
        try {
            Constructor<T> c = targetType.getConstructor(String.class);
            return c.newInstance(value);
        }
        catch (Exception e) {
            throw new TypeConversionException("No constructor taking one String argument found for type '" + targetType + "' (" + e.getMessage() + ")", e);
        }
    }

    public static Object convertTo(String valueString, String typeName) throws TypeConversionException, ClassNotFoundException {
        Class<?> clazz = ReflectionUtils.resolveType(typeName);
        return ReflectionUtils.convertString(valueString, clazz);
    }

    public static FormalParameter[] getFormalParameters(Method method) {
        int parameterCount = method.getParameterTypes().length;
        FormalParameter[] parameters = new FormalParameter[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            parameters[i] = new FormalParameter(method, i);
        }
        return parameters;
    }

    public static List<Class<?>> getSuperClasses(Class<?> clazz) {
        ArrayList superClasses = new ArrayList();
        ReflectionUtils.findSuperClasses(clazz, superClasses);
        return superClasses;
    }

    public static boolean isAssignable(Class<?> source, Class<?> target) {
        return ReflectionUtils.resolvePrimitiveClass(target).isAssignableFrom(ReflectionUtils.resolvePrimitiveClass(source));
    }

    public static Class<?> resolvePrimitiveClass(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        EJavaPrimitive primitive = EJavaPrimitive.getForPrimitiveClass(clazz);
        if (primitive == null) {
            throw new IllegalStateException("Did Java get a new primitive? " + clazz.getName());
        }
        return primitive.getWrapperClass();
    }

    static <T> T convertPrimitive(String value, Class<T> targetType) throws TypeConversionException {
        EJavaPrimitive primitive = EJavaPrimitive.getForPrimitiveOrWrapperClass(targetType);
        if (primitive == null) {
            throw new IllegalArgumentException("Type '" + targetType.getName() + "' is not a primitive type!");
        }
        try {
            switch (primitive) {
                case BOOLEAN: {
                    boolean b = "1".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
                    return (T)Boolean.valueOf(b);
                }
                case CHAR: {
                    return (T)Character.valueOf(value.charAt(0));
                }
                case BYTE: {
                    return (T)Byte.valueOf(value);
                }
                case SHORT: {
                    return (T)Short.valueOf(value);
                }
                case INT: {
                    return (T)Integer.valueOf(value);
                }
                case LONG: {
                    return (T)Long.valueOf(value);
                }
                case FLOAT: {
                    return (T)Float.valueOf(value);
                }
                case DOUBLE: {
                    return (T)Double.valueOf(value);
                }
            }
            throw new TypeConversionException("No conversion possible for " + (Object)((Object)primitive));
        }
        catch (NumberFormatException e) {
            throw new TypeConversionException("Value'" + value + "' can't be converted to type '" + targetType.getName() + "' (" + e.getMessage() + ").", e);
        }
    }

    public static Class<?> resolveType(String typeName) throws ClassNotFoundException {
        return ReflectionUtils.resolveType(typeName, null);
    }

    public static Class<?> resolveType(String typeName, ClassLoader classLoader) throws ClassNotFoundException {
        EJavaPrimitive primitive = EJavaPrimitive.getPrimitiveIgnoreCase(typeName);
        if (primitive != null) {
            return primitive.getClassObject();
        }
        if (classLoader == null) {
            return Class.forName(typeName);
        }
        return Class.forName(typeName, true, classLoader);
    }

    private static void findSuperClasses(Class<?> clazz, List<Class<?>> superClasses) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == null) {
            return;
        }
        superClasses.add(superClass);
        ReflectionUtils.findSuperClasses(superClass, superClasses);
    }

    public static Class<?> obtainMethodReturnType(Class<?> clazz, String methodName) throws NoSuchMethodException {
        for (Method method : clazz.getMethods()) {
            if (!ReflectionUtils.isValid(method, methodName)) continue;
            return method.getReturnType();
        }
        throw new NoSuchMethodException("Class " + clazz.getName() + " doesn't have parameterless method named " + methodName);
    }

    public static Class<?> obtainGenericMethodReturnType(Class<?> clazz, String methodName) throws NoSuchMethodException {
        if (clazz.isArray() || clazz.isEnum()) {
            throw new IllegalArgumentException("Doesn't work for arrays and enums.");
        }
        if (clazz.getTypeParameters().length != 0) {
            throw new IllegalArgumentException("Doesn't work for generic classes.");
        }
        for (Method method : clazz.getMethods()) {
            if (!ReflectionUtils.isValid(method, methodName)) continue;
            return new GenericTypeResolver(clazz).resolveGenericType(method.getGenericReturnType());
        }
        throw new NoSuchMethodException("Class " + clazz.getName() + " doesn't have parameterless method named " + methodName);
    }

    private static boolean isValid(Method method, String methodName) {
        return method.getName().equals(methodName) && method.getParameterTypes().length == 0 && !method.isBridge();
    }

    public static <T> T performNearestClassLookup(Class<?> clazz, Map<Class<?>, T> classMap) {
        LinkedList q = new LinkedList();
        q.add(clazz);
        while (!q.isEmpty()) {
            Class current = (Class)q.poll();
            if (classMap.containsKey(current)) {
                return classMap.get(current);
            }
            Class superClass = current.getSuperclass();
            if (superClass != null && superClass != Object.class) {
                q.add(superClass);
            }
            q.addAll(Arrays.asList(current.getInterfaces()));
        }
        return classMap.get(Object.class);
    }

    public static boolean isInstanceOfAny(Object o, Class<?> ... classes) {
        for (Class<?> c : classes) {
            if (!c.isInstance(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstanceOfAll(Object o, Class<?> ... classes) {
        for (Class<?> c : classes) {
            if (c.isInstance(o)) continue;
            return false;
        }
        return true;
    }

    public static Version obtainClassFileVersion(InputStream inputStream) throws IOException {
        DataInputStream classfile = new DataInputStream(inputStream);
        int magic = classfile.readInt();
        if (magic != -889275714) {
            return null;
        }
        int minorVersion = classfile.readUnsignedShort();
        int majorVersion = classfile.readUnsignedShort();
        return new Version(majorVersion, minorVersion);
    }

    public static HashMap<String, Version> getClassFileVersions(File jarFile) throws IOException {
        HashMap<String, Version> result = new HashMap<String, Version>();
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            InputStream entryStream = jar.getInputStream(entry);
            Version version = ReflectionUtils.obtainClassFileVersion(entryStream);
            result.put(entry.getName(), version);
            entryStream.close();
        }
        jar.close();
        return result;
    }

    public static <T> List<T> listInstances(List<?> objects, Class<T> type) {
        ArrayList filtered = new ArrayList();
        for (Object object : objects) {
            if (!type.isInstance(object)) continue;
            filtered.add(object);
        }
        return filtered;
    }

    public static Set<Class<?>> getAllInterfaces(Class<?> baseClass) {
        LinkedList q = new LinkedList();
        q.add(baseClass);
        HashSet result = new HashSet();
        if (baseClass.isInterface()) {
            result.add(baseClass);
        }
        while (!q.isEmpty()) {
            for (Class<?> iface : ((Class)q.poll()).getInterfaces()) {
                if (!result.add(iface)) continue;
                q.add(iface);
            }
        }
        return result;
    }

    public static List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (type != null && type.getPackage() != null && !type.getPackage().getName().equals("java.lang")) {
            fields.addAll(Arrays.asList(type.getDeclaredFields()));
            type = type.getSuperclass();
        }
        return fields;
    }

    public static Field getField(Class<?> type, String name) throws SecurityException {
        while (type != null) {
            try {
                return type.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                type = type.getSuperclass();
            }
        }
        return null;
    }

    public static <T> boolean isIterable(T parsedObject) {
        return parsedObject.getClass().isArray() || parsedObject instanceof Iterable;
    }

    public static Iterable<?> asIterable(Object arrayOrIterable) {
        if (arrayOrIterable instanceof Iterable) {
            return (Iterable)arrayOrIterable;
        }
        if (arrayOrIterable.getClass().isArray()) {
            Class<?> componentType = arrayOrIterable.getClass().getComponentType();
            if (componentType.isArray() || componentType.isPrimitive()) {
                ArrayList<Object> arrayContent = new ArrayList<Object>();
                for (int i = 0; i < Array.getLength(arrayOrIterable) - 1; ++i) {
                    arrayContent.add(Array.get(arrayOrIterable, i));
                }
                return arrayContent;
            }
            return Arrays.asList((Object[])arrayOrIterable);
        }
        throw new IllegalArgumentException("Array or Iterable expected, but was given " + arrayOrIterable.getClass().getCanonicalName());
    }

    public static <T extends Annotation> T getAnnotation(Class<?> element, Class<T> annotationClass) throws AssertionError {
        T annotation = element.getAnnotation(annotationClass);
        CCSMAssert.isNotNull(annotation, element + " is not annotated with @" + annotationClass.getSimpleName());
        return annotation;
    }
}

