/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.serialization.SerializationConsistencyException;
import org.conqat.lib.commons.serialization.SerializedEntityBase;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.objects.LongStringUtils;
import org.conqat.lib.commons.serialization.objects.SerializedObjectBase;
import org.conqat.lib.commons.serialization.objects.SerializedStringObject;

public class SerializedEntitySerializer {
    private static final int MAX_SHORT_BLOCK_DATA_SIZE = 255;
    private final DataOutputStream dos;
    private int nextHandle = 0x7E0000;
    private final Map<SerializedEntityBase, Integer> entityPool = new IdentityHashMap<SerializedEntityBase, Integer>();
    private final Map<String, Integer> stringPool = new HashMap<String, Integer>();

    private SerializedEntitySerializer(DataOutputStream dos) {
        this.dos = dos;
    }

    private void serialize(List<SerializedEntityBase> entities) throws IOException {
        this.dos.writeShort(-21267);
        this.dos.writeShort(5);
        for (SerializedEntityBase entity : entities) {
            if (entity == null) {
                this.dos.writeByte(112);
                continue;
            }
            entity.serialize(this.dos, this);
        }
    }

    public static void serializeToStream(List<SerializedEntityBase> entities, DataOutputStream dos) throws IOException {
        new SerializedEntitySerializer(dos).serialize(entities);
    }

    public static void serializeToStream(List<SerializedEntityBase> entities, OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        SerializedEntitySerializer.serializeToStream(entities, dos);
        dos.flush();
    }

    public static byte[] serializeToBytes(List<SerializedEntityBase> entities) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SerializedEntitySerializer.serializeToStream(entities, baos);
        baos.close();
        return baos.toByteArray();
    }

    public void serializeStringObject(String value) throws IOException {
        this.serializeStringObject(value, true);
    }

    public void serializeStringObject(String value, boolean useStringPool) throws IOException {
        Integer existingHandle;
        if (useStringPool && (existingHandle = this.stringPool.get(value)) != null) {
            this.dos.writeByte(113);
            this.dos.writeInt(existingHandle);
            return;
        }
        this.stringPool.put(value, this.obtainHandle());
        if (value.length() <= 65535) {
            this.dos.writeByte(116);
            this.dos.writeUTF(value);
        } else {
            this.dos.writeByte(124);
            LongStringUtils.writeUTF(value, this.dos);
        }
    }

    public void writeBlockData(byte[] data) throws IOException {
        if (data.length <= 255) {
            this.dos.write(119);
            this.dos.writeByte(data.length);
        } else {
            this.dos.write(122);
            this.dos.writeInt(data.length);
        }
        this.dos.write(data);
    }

    public void serializeAnnotationList(List<Object> rawDataList, SerializedEntityPool pool) throws IOException {
        for (Object rawData : rawDataList) {
            if (rawData instanceof byte[]) {
                this.writeBlockData((byte[])rawData);
                continue;
            }
            if (rawData instanceof Integer) {
                int handle = (Integer)rawData;
                SerializedEntitySerializer.serializeObject(handle, SerializedObjectBase.class, pool, this.dos, this);
                continue;
            }
            throw new SerializationConsistencyException("Unexpected type in class annotations!");
        }
    }

    public static void serializeObject(int handle, Class<? extends SerializedEntityBase> expectedType, SerializedEntityPool pool, DataOutputStream dos, SerializedEntitySerializer serializer) throws IOException {
        if (handle == 0) {
            dos.writeByte(112);
        } else {
            pool.getEntity(handle, expectedType).serialize(dos, serializer);
        }
    }

    private int obtainHandle() {
        return this.nextHandle++;
    }

    public boolean writeReference(SerializedEntityBase entity) throws IOException {
        CCSMAssert.isFalse(entity instanceof SerializedStringObject, "String are handled in a separate pool!");
        Integer existingHandle = this.entityPool.get(entity);
        if (existingHandle != null) {
            this.dos.writeByte(113);
            this.dos.writeInt(existingHandle);
            return true;
        }
        return false;
    }

    public void registerHandle(SerializedEntityBase entity) throws IOException {
        if (this.entityPool.containsKey(entity)) {
            throw new IOException("Duplicate registration of entity " + entity);
        }
        this.entityPool.put(entity, this.obtainHandle());
    }
}

