/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization.classes;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.serialization.SerializedEntityBase;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;

public abstract class SerializedClassBase
extends SerializedEntityBase {
    protected int superClassHandle = 0;
    private final List<Object> classAnnotations = new ArrayList<Object>();

    protected SerializedClassBase(DataInputStream din, SerializedEntityPool pool, SerializedEntityParser parser) throws IOException {
        super(pool);
        this.parseClass(din, pool, parser);
        this.readClassAnnotation(din, parser);
        this.readSuperClassDescription(parser);
    }

    protected SerializedClassBase(SerializedEntityPool pool) {
        super(pool);
    }

    protected abstract void parseClass(DataInputStream var1, SerializedEntityPool var2, SerializedEntityParser var3) throws IOException;

    private void readSuperClassDescription(SerializedEntityParser parser) throws IOException {
        this.superClassHandle = parser.parseClassDesc();
    }

    private void readClassAnnotation(DataInputStream din, SerializedEntityParser parser) throws IOException {
        block5: while (true) {
            din.mark(1);
            byte next = din.readByte();
            switch (next) {
                case 120: {
                    return;
                }
                case 119: {
                    this.classAnnotations.add(SerializedClassBase.readBlockData(din, din.readUnsignedByte()));
                    continue block5;
                }
                case 122: {
                    this.classAnnotations.add(SerializedClassBase.readBlockData(din, din.readInt()));
                    continue block5;
                }
            }
            din.reset();
            this.classAnnotations.add(parser.parseContent());
        }
    }

    private static byte[] readBlockData(DataInputStream din, int length) throws IOException {
        byte[] result = new byte[length];
        din.readFully(result);
        return result;
    }

    @Override
    protected final void serializeContent(DataOutputStream dos, SerializedEntitySerializer serializer) throws IOException {
        serializer.registerHandle(this);
        this.serializeClass(dos, serializer);
        this.serializeClassAnnotation(dos, serializer);
        this.serializeSuperClass(dos, serializer);
    }

    protected abstract void serializeClass(DataOutputStream var1, SerializedEntitySerializer var2) throws IOException;

    private void serializeSuperClass(DataOutputStream dos, SerializedEntitySerializer serializer) throws IOException {
        SerializedEntitySerializer.serializeObject(this.superClassHandle, SerializedClassBase.class, this.pool, dos, serializer);
    }

    private void serializeClassAnnotation(DataOutputStream dos, SerializedEntitySerializer serializer) throws IOException {
        serializer.serializeAnnotationList(this.classAnnotations, this.pool);
        dos.writeByte(120);
    }

    public int getSuperClassHandle() {
        return this.superClassHandle;
    }
}

