/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization.classes;

import java.io.IOException;
import org.conqat.lib.commons.serialization.SerializationConsistencyException;
import org.conqat.lib.commons.serialization.classes.SerializedBooleanField;
import org.conqat.lib.commons.serialization.classes.SerializedByteField;
import org.conqat.lib.commons.serialization.classes.SerializedCharField;
import org.conqat.lib.commons.serialization.classes.SerializedDoubleField;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedFloatField;
import org.conqat.lib.commons.serialization.classes.SerializedIntField;
import org.conqat.lib.commons.serialization.classes.SerializedLongField;
import org.conqat.lib.commons.serialization.classes.SerializedShortField;

public abstract class SerializedPrimitiveFieldBase
extends SerializedFieldBase {
    protected SerializedPrimitiveFieldBase(String name) {
        super(name);
    }

    protected <T> T ensureType(Object value, Class<T> type) throws SerializationConsistencyException {
        if (!type.isInstance(value)) {
            String actualType = null;
            if (value != null) {
                actualType = value.getClass().getName();
            }
            throw new SerializationConsistencyException("Would have expected type " + type + " for field " + this.getName() + " but was " + actualType);
        }
        return (T)value;
    }

    public static SerializedPrimitiveFieldBase fromTypeCode(char typeCode, String fieldName) throws IOException {
        switch (typeCode) {
            case 'B': {
                return new SerializedByteField(fieldName);
            }
            case 'C': {
                return new SerializedCharField(fieldName);
            }
            case 'D': {
                return new SerializedDoubleField(fieldName);
            }
            case 'F': {
                return new SerializedFloatField(fieldName);
            }
            case 'I': {
                return new SerializedIntField(fieldName);
            }
            case 'J': {
                return new SerializedLongField(fieldName);
            }
            case 'S': {
                return new SerializedShortField(fieldName);
            }
            case 'Z': {
                return new SerializedBooleanField(fieldName);
            }
        }
        throw new SerializationConsistencyException("Unrecognized type code: " + typeCode);
    }
}

