/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization.classes;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedClassBase;
import org.conqat.lib.commons.string.StringUtils;

public class SerializedProxyClass
extends SerializedClassBase {
    private List<String> proxyInterfaceNames;

    public SerializedProxyClass(DataInputStream din, SerializedEntityPool pool, SerializedEntityParser parser) throws IOException {
        super(din, pool, parser);
    }

    @Override
    protected void parseClass(DataInputStream din, SerializedEntityPool pool, SerializedEntityParser parser) throws IOException {
        int proxyClassCount = din.readInt();
        this.proxyInterfaceNames = new ArrayList<String>();
        for (int i = 0; i < proxyClassCount; ++i) {
            this.proxyInterfaceNames.add(din.readUTF());
        }
    }

    @Override
    protected void serializeClass(DataOutputStream dos, SerializedEntitySerializer serializer) throws IOException {
        dos.writeByte(125);
        dos.writeInt(this.proxyInterfaceNames.size());
        for (String proxyInterfaceName : this.proxyInterfaceNames) {
            dos.writeUTF(proxyInterfaceName);
        }
    }

    public String toString() {
        return "Proxy class for " + StringUtils.concat(this.proxyInterfaceNames, "|");
    }
}

