/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization.objects;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class LongStringUtils {
    private static final int SINGLE_BYTE_LIMIT = 127;
    private static final int DOUBLE_BYTE_LIMIT = 2047;
    public static final int MAX_SHORT_STRING_LENGTH = 65535;

    public static String readLongString(DataInputStream in) throws IOException {
        int utfLength = (int)in.readLong();
        byte[] bytes = new byte[utfLength];
        in.readFully(bytes);
        int count = 0;
        int charCount = 0;
        char[] chars = new char[utfLength];
        block4: while (count < utfLength) {
            int c = bytes[count] & 0xFF;
            if (c <= 127) {
                ++count;
                chars[charCount++] = (char)c;
                continue;
            }
            switch (c >> 4) {
                case 12: 
                case 13: {
                    count = LongStringUtils.incrementChecked(count, utfLength, 2);
                    chars[charCount++] = LongStringUtils.extractTwoByteChar(bytes, count - 2);
                    continue block4;
                }
                case 14: {
                    count = LongStringUtils.incrementChecked(count, utfLength, 3);
                    chars[charCount++] = LongStringUtils.extractThreeByteChar(bytes, count - 3);
                    continue block4;
                }
            }
            LongStringUtils.throwMalformedIf(true, count);
        }
        return new String(chars, 0, charCount);
    }

    private static char extractThreeByteChar(byte[] bytes, int index) throws UTFDataFormatException {
        byte char2 = bytes[index + 1];
        byte char3 = bytes[index + 2];
        LongStringUtils.throwMalformedIf((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128, index + 1);
        return (char)((bytes[index] & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
    }

    private static char extractTwoByteChar(byte[] bytes, int index) throws UTFDataFormatException {
        byte char2 = bytes[index + 1];
        LongStringUtils.throwMalformedIf((char2 & 0xC0) != 128, index + 2);
        return (char)((bytes[index] & 0x1F) << 6 | char2 & 0x3F);
    }

    private static void throwMalformedIf(boolean condition, int count) throws UTFDataFormatException {
        if (condition) {
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
    }

    private static int incrementChecked(int count, int utfLength, int increment) throws UTFDataFormatException {
        if ((count += increment) > utfLength) {
            throw new UTFDataFormatException("malformed input: partial character at end");
        }
        return count;
    }

    public static void writeUTF(String string, DataOutputStream out) throws IOException {
        int utfLength = string.chars().map(LongStringUtils::utfSize).sum();
        out.writeLong(utfLength);
        byte[] bytes = new byte[utfLength];
        int index = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytes[index++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytes[index++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytes[index++] = (byte)(0x80 | c >> 6 & 0x3F);
            } else {
                bytes[index++] = (byte)(0xC0 | c >> 6 & 0x1F);
            }
            bytes[index++] = (byte)(0x80 | c & 0x3F);
        }
        out.write(bytes);
    }

    private static int utfSize(int character) {
        if (character >= 1 && character <= 127) {
            return 1;
        }
        if (character > 2047) {
            return 3;
        }
        return 2;
    }
}

