/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization.objects;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedClassBase;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.objects.SerializedClassValues;
import org.conqat.lib.commons.serialization.objects.SerializedObjectBase;
import org.conqat.lib.commons.string.StringUtils;

public class SerializedObject
extends SerializedObjectBase {
    private final List<SerializedClassValues> fieldSets = new ArrayList<SerializedClassValues>();

    public SerializedObject(DataInputStream din, SerializedEntityPool pool, SerializedEntityParser parser, int classHandle) throws IOException {
        super(pool, classHandle);
        for (SerializedClass serializedClass : this.getPlainClassHierarchy()) {
            this.fieldSets.add(new SerializedClassValues(serializedClass, din, parser));
        }
    }

    public SerializedObject(int classHandle, List<SerializedClassValues> fieldSets, SerializedEntityPool pool) {
        super(pool, classHandle);
        this.fieldSets.addAll(fieldSets);
    }

    @Override
    protected byte getObjectTagConstant() {
        return 115;
    }

    @Override
    protected void serializeObjectContent(DataOutputStream dos, SerializedEntitySerializer serializer) throws IOException {
        int index = 0;
        for (SerializedClass serializedClass : this.getPlainClassHierarchy()) {
            SerializedClassValues fieldSet = this.fieldSets.get(index++);
            fieldSet.serialize(serializedClass, this.pool, dos, serializer);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String className = "<unknown>";
        try {
            className = this.pool.getEntity(this.classHandle, SerializedClassBase.class).toString();
            builder.append("Object " + this.getHandle() + ": " + className + StringUtils.LINE_SEPARATOR);
            int index = 0;
            for (SerializedClass serializedClass : this.getPlainClassHierarchy()) {
                SerializedObject.appendFieldSet(this.fieldSets.get(index++), serializedClass, builder);
            }
        }
        catch (IOException e) {
            builder.append("Could not resolve hierarchy for class " + className + ": " + e.getMessage());
        }
        return builder.toString();
    }

    private static void appendFieldSet(SerializedClassValues fieldSet, SerializedClass serializedClass, StringBuilder builder) {
        if (fieldSet.hasFieldValues()) {
            int fieldIndex = 0;
            for (SerializedFieldBase field : serializedClass.getFields()) {
                builder.append("  " + serializedClass.getName() + "#" + field.getName() + ": " + fieldSet.getValue(fieldIndex++) + StringUtils.LINE_SEPARATOR);
            }
        } else {
            builder.append("  " + serializedClass.getName() + ": <no data>");
        }
    }

    public Object getFieldValue(String name) throws IOException {
        Pair<SerializedClassValues, Integer> fieldSetAndValue = this.getFieldSetAndIndex(name);
        if (fieldSetAndValue == null) {
            return null;
        }
        return ((SerializedClassValues)fieldSetAndValue.getFirst()).getValue((Integer)fieldSetAndValue.getSecond());
    }

    public void setFieldValue(String name, Object value) throws IOException {
        Pair<SerializedClassValues, Integer> fieldSetAndValue = this.getFieldSetAndIndex(name);
        if (fieldSetAndValue != null) {
            ((SerializedClassValues)fieldSetAndValue.getFirst()).setValue((Integer)fieldSetAndValue.getSecond(), value);
        }
    }

    public void removeFieldValue(String name) throws IOException {
        Pair<SerializedClassValues, Integer> fieldSetAndValue = this.getFieldSetAndIndex(name);
        if (fieldSetAndValue != null) {
            ((SerializedClassValues)fieldSetAndValue.getFirst()).removeValue((Integer)fieldSetAndValue.getSecond());
        }
    }

    private Pair<SerializedClassValues, Integer> getFieldSetAndIndex(String fieldName) throws IOException {
        int classIndex = 0;
        for (SerializedClass serializedClass : this.getPlainClassHierarchy()) {
            SerializedFieldBase field = serializedClass.getField(fieldName);
            if (field != null) {
                int index = serializedClass.getFields().indexOf(field);
                SerializedClassValues fieldSet = this.fieldSets.get(classIndex);
                return new Pair<SerializedClassValues, Integer>(fieldSet, index);
            }
            ++classIndex;
        }
        return null;
    }

    public int getFieldSetCount() {
        return this.fieldSets.size();
    }

    public SerializedClassValues getFieldSet(int index) {
        return this.fieldSets.get(index);
    }
}

