/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.serialization.SerializedEntityBase;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.objects.SerializedClassValues;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.objects.SerializedStringObject;

public class SerializationMigrationUtils {
    public static void transformStringsInHashSet(SerializedObject setObject, IStringTransformation transformation, SerializedEntityPool pool) throws IOException {
        SerializedClass setClass = SerializationMigrationUtils.findClassInHierarchy(setObject, HashSet.class);
        SerializedClassValues fieldSets = setObject.getFieldSet(setObject.getPlainClassHierarchy().indexOf(setClass));
        for (Object data : fieldSets.getPreFieldData()) {
            SerializedEntityBase containedElement;
            if (!(data instanceof Integer) || !((containedElement = pool.getEntity((Integer)data, SerializedEntityBase.class)) instanceof SerializedStringObject)) continue;
            SerializedStringObject stringContent = (SerializedStringObject)containedElement;
            stringContent.setValue(transformation.transform(stringContent.getValue()));
        }
    }

    public static <T extends SerializedEntityBase> List<T> getObjectsFromArrayList(SerializedObject setObject, SerializedEntityPool pool) throws IOException {
        SerializedClass setClass = SerializationMigrationUtils.findClassInHierarchy(setObject, ArrayList.class);
        SerializedClassValues fieldSets = setObject.getFieldSet(setObject.getPlainClassHierarchy().indexOf(setClass));
        ArrayList<SerializedEntityBase> objects = new ArrayList<SerializedEntityBase>();
        for (Object data : fieldSets.getPostFieldData()) {
            if (!(data instanceof Integer)) continue;
            SerializedEntityBase containedElement = pool.getEntity((Integer)data, SerializedEntityBase.class);
            objects.add(containedElement);
        }
        return objects;
    }

    public static SerializedClass findClassInHierarchy(SerializedObject setObject, Class<?> classToFind) throws IOException {
        for (SerializedClass classObject : setObject.getPlainClassHierarchy()) {
            if (!classToFind.getName().equals(classObject.getName())) continue;
            return classObject;
        }
        CCSMAssert.fail("Only works on " + classToFind.getName() + " objects!");
        return null;
    }

    public static <T> T serializeRootEntities(SerializedEntityPool entityPool) throws AssertionError, IOException, ClassNotFoundException {
        List<SerializedEntityBase> rootEntities = entityPool.getRootEntities();
        byte[] newValue = SerializedEntitySerializer.serializeToBytes(rootEntities);
        return (T)SerializationUtils.deserializeFromByteArray(newValue);
    }

    public static void deleteField(SerializedEntityPool pool, String className, String fieldName) throws IOException {
        SerializedClass migratedClass = pool.findClass(className);
        if (migratedClass == null) {
            return;
        }
        for (SerializedObject object : pool.getRootEntities(SerializedObject.class)) {
            if (object.getClassHandle() != migratedClass.getHandle()) continue;
            object.removeFieldValue(fieldName);
        }
        migratedClass.removeField(fieldName);
    }

    public static interface IStringTransformation {
        public String transform(String var1);
    }
}

