/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import java.math.BigInteger;
import java.util.Comparator;
import org.conqat.lib.commons.string.StringUtils;

public class NumbersAwareStringComparator
implements Comparator<String> {
    public static final NumbersAwareStringComparator INSTANCE = new NumbersAwareStringComparator();

    @Override
    public int compare(String s1, String s2) {
        String prefix2;
        if (StringUtils.isEmpty(s1) || StringUtils.isEmpty(s2)) {
            return StringUtils.compare(s1, s2);
        }
        String prefix1 = NumbersAwareStringComparator.getPrefix(s1);
        if (prefix1.equals(prefix2 = NumbersAwareStringComparator.getPrefix(s2))) {
            return this.compare(StringUtils.stripPrefix(s1, prefix1), StringUtils.stripPrefix(s2, prefix2));
        }
        if (NumbersAwareStringComparator.startsWithDigit(prefix1) && NumbersAwareStringComparator.startsWithDigit(prefix2)) {
            int comparisonResult = new BigInteger(prefix1).compareTo(new BigInteger(prefix2));
            if (comparisonResult == 0) {
                return this.compare(StringUtils.stripPrefix(s1, prefix1), StringUtils.stripPrefix(s2, prefix2));
            }
            return comparisonResult;
        }
        return prefix1.compareTo(prefix2);
    }

    private static boolean startsWithDigit(String s) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        char first = s.charAt(0);
        return Character.isDigit(first);
    }

    private static String getPrefix(String s) {
        if (NumbersAwareStringComparator.startsWithDigit(s)) {
            return s.replaceAll("[\\D]+.*", "");
        }
        return s.replaceAll("[\\d]+.*", "");
    }
}

