/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.EntityArrays;
import org.apache.commons.text.translate.LookupTranslator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.EByteOrderMark;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.LineSplitter;

public class StringUtils {
    private static final Pattern LEADING_WHITESPACE_PATTERN = Pattern.compile("^[\\t\\p{Zs}]+", 8);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String LINE_FEED = "\n";
    public static final String EMPTY_STRING = "";
    public static final String SPACE = " ";
    public static final char SPACE_CHAR = ' ';
    public static final String TAB = "\t";
    public static final String TWO_SPACES = "  ";
    public static final String DOT = ".";
    public static final String THREE_DOTS = "...";
    public static final String ELLIPSIS = "\u2026";
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private static final NumberFormat PERCENTAGE_FORMAT = NumberFormat.getPercentInstance();
    private static final Random RANDOM = new Random();
    private static final char[] HEX_CHARACTERS = "0123456789ABCDEF".toCharArray();
    private static final List<Character> MARKDOWN_ESCAPE_CHARACTERS = Arrays.asList(Character.valueOf('['), Character.valueOf(']'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('#'), Character.valueOf('_'), Character.valueOf('~'), Character.valueOf('^'), Character.valueOf('+'), Character.valueOf('='), Character.valueOf('>'));
    private static final Map<CharSequence, CharSequence> MARKDOWN_ESCAPE_MAP = MARKDOWN_ESCAPE_CHARACTERS.stream().collect(Collectors.toMap(String::valueOf, characterToBeEscaped -> "\\" + characterToBeEscaped));
    public static final Map<CharSequence, CharSequence> ESCAPE_NEWLINE;

    public static String center(String string, int length, char c) {
        if (string.length() >= length) {
            return string;
        }
        int strLen = string.length();
        int fillLen = (length - strLen) / 2;
        String leftFiller = StringUtils.fillString(fillLen, c);
        if ((length - strLen) % 2 != 0) {
            ++fillLen;
        }
        String rightFiller = StringUtils.fillString(fillLen, c);
        return leftFiller + string + rightFiller;
    }

    public static int compare(@Nullable String a, @Nullable String b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static String concat(Iterable<?> iterable) {
        return StringUtils.concat(iterable, SPACE);
    }

    public static @Nullable String concat(@Nullable Iterable<?> iterable, @Nullable String separator) {
        if (iterable == null) {
            return null;
        }
        return StringUtils.concat(iterable.iterator(), separator);
    }

    public static @Nullable String concat(@Nullable Iterator<?> iterator, @Nullable String separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY_STRING;
        }
        if (separator == null) {
            separator = EMPTY_STRING;
        }
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static String concat(Object[] array) {
        return StringUtils.concat(array, SPACE);
    }

    public static @Nullable String concat(Object @Nullable [] array, @Nullable String separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.concat(Arrays.asList(array), separator);
    }

    public static String joinDifferentLastDelimiter(List<String> items, String delimiter, String lastDelimiter) {
        int last = items.size() - 1;
        return String.join((CharSequence)lastDelimiter, String.join((CharSequence)delimiter, items.subList(0, last)), items.get(last));
    }

    public static String[] concat(String[] array1, String[] array2) {
        String[] result = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static String fillString(int length, char c) {
        char[] characters = new char[length];
        Arrays.fill(characters, c);
        return new String(characters);
    }

    public static String flushLeft(String string, int length, char c) {
        int gap = length - string.length();
        if (gap <= 0) {
            return string;
        }
        return string + StringUtils.fillString(gap, c);
    }

    public static String flushRight(String string, int length, char c) {
        int gap = length - string.length();
        if (gap <= 0) {
            return string;
        }
        return StringUtils.fillString(gap, c) + string;
    }

    public static String format(Number number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String formatAsPercentage(Number number) {
        return PERCENTAGE_FORMAT.format(number);
    }

    public static String getFirstLine(String string) {
        LineSplitter lineSplitter = new LineSplitter(string);
        return lineSplitter.next();
    }

    public static String getFirstParts(String string, int partNumber, char separator) {
        if (partNumber < 0 || string == null) {
            return string;
        }
        int idx = 0;
        for (int i = 0; i < partNumber; ++i) {
            if ((idx = string.indexOf(separator, idx + 1)) != -1) continue;
            return string;
        }
        return string.substring(0, idx);
    }

    public static @Nullable HashMap<String, @Nullable String> getKeyValuePairs(@Nullable String keyValueString) {
        String[] pairs;
        if (keyValueString == null) {
            return null;
        }
        HashMap<String, @Nullable String> result = new HashMap<String, String>();
        if (keyValueString.trim().equals(EMPTY_STRING)) {
            return result;
        }
        for (String pair : pairs = keyValueString.split(",")) {
            int index = pair.indexOf(61);
            if (index < 0) {
                result.put(pair.trim(), null);
                continue;
            }
            String key = pair.substring(0, index).trim();
            String value = pair.substring(index + 1).trim();
            result.put(key, value);
        }
        return result;
    }

    public static String getFirstPart(String string, String separator) {
        int idx = string.indexOf(separator);
        if (idx >= 0) {
            return string.substring(0, idx);
        }
        return string;
    }

    public static String getFirstPart(String string, char separator) {
        return StringUtils.getFirstPart(string, String.valueOf(separator));
    }

    public static String getLastPart(String string, String separator) {
        int idx = string.lastIndexOf(separator);
        if (idx >= 0) {
            return string.substring(idx + separator.length());
        }
        return string;
    }

    public static String getLastPart(String string, char separator) {
        return StringUtils.getLastPart(string, String.valueOf(separator));
    }

    public static Pair<String, String> splitAtLast(String string, char separator) {
        int idx = string.lastIndexOf(separator);
        if (idx == -1) {
            return new Pair<String, String>(string, EMPTY_STRING);
        }
        return new Pair<String, String>(string.substring(0, idx), string.substring(idx + 1));
    }

    public static int indexOf(String[] array, String string) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].trim().equals(string.trim())) continue;
            return i;
        }
        return -1;
    }

    public static boolean isEmpty(String text) {
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)text);
    }

    public static boolean containsLetter(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isLetter(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String s1, String s2) {
        return s1.toLowerCase().contains(s2.toLowerCase());
    }

    public static boolean containsAll(String s, String ... substrings) {
        for (String substring : substrings) {
            if (s.contains(substring)) continue;
            return false;
        }
        return true;
    }

    public static String randomString(int length) {
        return StringUtils.randomString(length, RANDOM);
    }

    public static String randomString(int length, Random random) {
        char[] characters = new char[length];
        for (int i = 0; i < length; ++i) {
            characters[i] = (char)(random.nextInt(93) + 33);
        }
        return new String(characters);
    }

    public static String[] randomStringArray(int length, int stringLength) {
        String[] array = new String[length];
        for (int i = 0; i < length; ++i) {
            array[i] = StringUtils.randomString(stringLength);
        }
        return array;
    }

    public static String generateString(int length, int seed) {
        Random seededRandomizer = new Random(seed);
        return StringUtils.randomString(length, seededRandomizer);
    }

    public static String[] generateStringArray(int length, int stringLength, int seed) {
        String[] array = new String[length];
        for (int i = 0; i < length; ++i) {
            array[i] = StringUtils.generateString(stringLength, seed + i);
        }
        return array;
    }

    public static String removeLastPart(String string, char separator) {
        int idx = string.lastIndexOf(separator);
        if (idx == -1) {
            return string;
        }
        return string.substring(0, idx);
    }

    public static String replaceFromMap(String string, @Nullable Map<String, String> replacements) {
        if (replacements == null) {
            return string;
        }
        StringBuilder sb = new StringBuilder(string);
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            int start = sb.indexOf(key, 0);
            while (start > -1) {
                int end = start + key.length();
                int nextSearchStart = start + value.length();
                sb.replace(start, end, value);
                start = sb.indexOf(key, nextSearchStart);
            }
        }
        return sb.toString();
    }

    public static String removeAll(String string, String ... stringsToRemove) {
        if (stringsToRemove == null || stringsToRemove.length == 0) {
            return string;
        }
        StringBuilder sb = new StringBuilder(string);
        for (String key : stringsToRemove) {
            int start = sb.indexOf(key, 0);
            while (start > -1) {
                int end = start + key.length();
                sb.delete(start, end);
                start = sb.indexOf(key, start);
            }
        }
        return sb.toString();
    }

    public static String normalizeLineSeparatorsPlatformSpecific(String string) {
        return StringUtils.replaceLineBreaks(string, LINE_SEPARATOR);
    }

    public static String normalizeLineSeparatorsPlatformIndependent(String string) {
        return StringUtils.replaceLineBreaks(string, LINE_FEED);
    }

    public static String replaceLineBreaks(String string, String symbol) {
        StringBuilder builder = new StringBuilder();
        LineSplitter lineSplitter = new LineSplitter(string);
        lineSplitter.setIncludeTrailingEmptyLine(true);
        for (String line : lineSplitter) {
            builder.append(line);
            if (!lineSplitter.hasNext()) continue;
            builder.append(symbol);
        }
        return builder.toString();
    }

    public static String[] splitLines(@Nullable String content) {
        List<String> lineList = StringUtils.splitLinesAsList(content);
        String[] result = new String[lineList.size()];
        lineList.toArray(result);
        return result;
    }

    public static int countCharacter(String content, char character) {
        int count = 0;
        for (char c : content.toCharArray()) {
            if (c != character) continue;
            ++count;
        }
        return count;
    }

    public static int countLines(String content) {
        return StringUtils.countLines(content, false);
    }

    public static int countLines(@Nullable String content, boolean includeTrailingNewline) {
        if (content == null || content.isEmpty()) {
            return 0;
        }
        int lines = 1;
        int index = 0;
        int contentLength = content.length();
        while (index < contentLength) {
            char c = content.charAt(index);
            ++index;
            if (c == '\n' || c == '\u0085') {
                if (index >= contentLength && !includeTrailingNewline) continue;
                ++lines;
                continue;
            }
            if (c != '\r') continue;
            if (index < contentLength && content.charAt(index) == '\n') {
                ++index;
            }
            if (index >= contentLength) continue;
            ++lines;
        }
        return lines;
    }

    public static List<String> splitLinesAsList(@Nullable String content) {
        return StringUtils.splitLinesAsList(content, false);
    }

    public static List<String> splitLinesAsList(@Nullable String content, boolean includeTrailingEmptyLine) {
        ArrayList<String> result = new ArrayList<String>();
        LineSplitter lineSplitter = new LineSplitter(content);
        lineSplitter.setIncludeTrailingEmptyLine(includeTrailingEmptyLine);
        for (String line : lineSplitter) {
            result.add(line);
        }
        return result;
    }

    public static String addPrefix(String string, String separator, String prefix) {
        if (StringUtils.isEmpty(prefix)) {
            return string;
        }
        return prefix + separator + string;
    }

    public static String addSuffix(String string, String separator, String suffix) {
        if (StringUtils.isEmpty(suffix)) {
            return string;
        }
        return string + separator + suffix;
    }

    public static String stripPrefix(String string, String prefix) {
        if (string.startsWith(prefix)) {
            return string.substring(prefix.length());
        }
        return string;
    }

    public static String stripPrefixIgnoreCase(String string, String prefix) {
        if (StringUtils.startsWithIgnoreCase(string, prefix)) {
            return string.substring(prefix.length());
        }
        return string;
    }

    public static String stripSuffix(String string, String suffix) {
        if (string.endsWith(suffix)) {
            return string.substring(0, string.length() - suffix.length());
        }
        return string;
    }

    public static String stripDigits(String string) {
        return string.replaceAll("[0-9]", EMPTY_STRING);
    }

    public static String stripTrailingDigits(String string) {
        return string.replaceAll("\\d+$", EMPTY_STRING);
    }

    public static String toString(Map<?, ?> map) {
        return StringUtils.toString(map, EMPTY_STRING);
    }

    public static String toString(Map<?, ?> map, String indent) {
        StringBuilder result = new StringBuilder();
        Iterator<?> keyIterator = map.keySet().iterator();
        while (keyIterator.hasNext()) {
            result.append(indent);
            Object key = keyIterator.next();
            result.append(key);
            result.append(" = ");
            result.append(map.get(key));
            if (!keyIterator.hasNext()) continue;
            result.append(LINE_SEPARATOR);
        }
        return result.toString();
    }

    public static String obtainStackTrace(Throwable throwable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        throwable.printStackTrace(printWriter);
        FileSystemUtils.close(printWriter);
        FileSystemUtils.close(result);
        return result.toString();
    }

    public static boolean startsWithOneOf(String string, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!string.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithOneOf(String string, Iterable<String> prefixes) {
        for (String prefix : prefixes) {
            if (!string.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(String string, String prefix) {
        return string.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public static boolean containsOneOf(String text, String ... strings) {
        return StringUtils.containsOneOf(text, Arrays.asList(strings));
    }

    public static boolean containsOneOf(String text, Iterable<String> strings) {
        for (String substring : strings) {
            if (!text.contains(substring)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithIgnoreCase(String string, String suffix) {
        return string.toLowerCase().endsWith(suffix.toLowerCase());
    }

    public static boolean endsWithOneOf(String string, String ... suffixes) {
        for (String suffix : suffixes) {
            if (!string.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static String prefixLines(String string, String prefix, boolean prefixFirstLine) {
        String[] lines = StringUtils.splitLines(string.trim());
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0 || prefixFirstLine) {
                result.append(prefix);
            }
            result.append(lines[i]);
            if (i >= lines.length - 1) continue;
            result.append(LINE_SEPARATOR);
        }
        return result.toString();
    }

    public static Character[] splitChars(String s) {
        Character[] result = new Character[s.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Character.valueOf(s.charAt(i));
        }
        return result;
    }

    public static String capitalize(String string) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String decapitalize(String string) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static String wrapLongLines(String s, int maxLineLength) {
        String[] words = s.split("\\s+");
        StringBuilder sb = new StringBuilder();
        int lineLength = 0;
        for (String word : words) {
            if (word.length() == 0) continue;
            if (lineLength > 0) {
                if (lineLength + 1 + word.length() > maxLineLength) {
                    sb.append(LINE_SEPARATOR);
                    lineLength = 0;
                } else {
                    sb.append(SPACE);
                    ++lineLength;
                }
            }
            sb.append(word);
            lineLength += word.length();
        }
        return sb.toString();
    }

    public static String longestCommonPrefix(String s, String t) {
        int n = Math.min(s.length(), t.length());
        for (int i = 0; i < n; ++i) {
            if (s.charAt(i) == t.charAt(i)) continue;
            return s.substring(0, i);
        }
        return s.substring(0, n);
    }

    public static String longestCommonSuffix(String s, String t) {
        return StringUtils.reverse(StringUtils.longestCommonPrefix(StringUtils.reverse(s), StringUtils.reverse(t)));
    }

    public static String reverse(String s) {
        return new StringBuilder(s).reverse().toString();
    }

    public static String longestCommonPrefix(Iterable<String> strings) {
        Iterator<String> iterator = strings.iterator();
        CCSMAssert.isTrue(iterator.hasNext(), "Expected are at least 2 strings");
        String commonPrefix = iterator.next();
        CCSMAssert.isTrue(iterator.hasNext(), "Expected are at least 2 strings");
        while (iterator.hasNext() && (commonPrefix = StringUtils.longestCommonPrefix(commonPrefix, iterator.next())).length() != 0) {
        }
        return commonPrefix;
    }

    public static String removeWhitespace(String content) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (Character.isWhitespace(c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    public static String removeWhitespaceAtBeginningOfLine(String content) {
        return LEADING_WHITESPACE_PATTERN.matcher(content).replaceAll(EMPTY_STRING);
    }

    public static String createUniqueName(String baseName, Set<String> usedNames) {
        String name = baseName;
        int i = 1;
        while (usedNames.contains(name)) {
            name = baseName + ++i;
        }
        return name;
    }

    public static String camelCaseToUnderscored(String s) {
        return StringUtils.stripPrefix(s.replaceAll("([A-Z][a-z])", "_$1").toUpperCase(), "_");
    }

    public static String encodeAsHex(byte[] data) {
        char[] hexChars = new char[data.length * 2];
        for (int j = 0; j < data.length; ++j) {
            int v = data[j] & 0xFF;
            hexChars[j * 2] = HEX_CHARACTERS[v >>> 4];
            hexChars[j * 2 + 1] = HEX_CHARACTERS[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] decodeFromHex(String s) {
        byte[] result = new byte[s.length() / 2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16);
        }
        return result;
    }

    public static String format(double number, @Nullable NumberFormat numberFormat) {
        if (numberFormat == null) {
            return String.valueOf(number);
        }
        return numberFormat.format(number);
    }

    public static String escapeRegexReplacementString(String replacement) {
        return replacement.replaceAll("([$\\\\])", "\\\\$1");
    }

    public static byte @Nullable [] stringToBytes(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static @Nullable String bytesToString(byte @Nullable [] b) {
        if (b == null) {
            return null;
        }
        return new String(b, StandardCharsets.UTF_8);
    }

    public static @Nullable String bytesToString(byte @Nullable [] b, Charset encoding) {
        if (b == null) {
            return null;
        }
        Optional<EByteOrderMark> bom = EByteOrderMark.determineBOM(b);
        Charset detectedEncoding = bom.map(EByteOrderMark::getEncoding).orElse(encoding);
        int bytesToSkip = bom.map(EByteOrderMark::getBOMLength).orElse(0);
        return new String(b, bytesToSkip, b.length - bytesToSkip, detectedEncoding);
    }

    public static List<@Nullable String> asStringList(Collection<@Nullable ?> objects) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object o : objects) {
            result.add(String.valueOf(o));
        }
        return result;
    }

    public static <T> List<@Nullable String> toStrings(Collection<@Nullable T> objects) {
        ArrayList<String> strings = new ArrayList<String>();
        for (T t : objects) {
            if (t == null) {
                strings.add(null);
                continue;
            }
            strings.add(t.toString());
        }
        return strings;
    }

    public static @Nullable String[] toStringArray(Object[] array) {
        return CollectionUtils.toArray(StringUtils.toStrings(Arrays.asList(array)), String.class);
    }

    public static InputStream toInputStream(String string) {
        return StringUtils.toInputStream(string, StandardCharsets.UTF_8);
    }

    public static InputStream toInputStream(String string, Charset charset) {
        return new ByteArrayInputStream(string.getBytes(charset));
    }

    public static String fromInputStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = inputStream.read(buffer);
        while (length != -1) {
            result.write(buffer, 0, length);
            length = inputStream.read(buffer);
        }
        return result.toString(StandardCharsets.UTF_8.name());
    }

    public static String truncate(String string, int length, String suffix) {
        CCSMAssert.isTrue(length >= suffix.length(), "Expected length >= suffix.length()");
        if (string.length() <= length) {
            return string;
        }
        return string.substring(0, length - suffix.length()) + suffix;
    }

    public static String truncate(String string, int length) {
        return StringUtils.truncate(string, length, EMPTY_STRING);
    }

    public static String truncateWithThreeDots(String string, int length) {
        return StringUtils.truncate(string, length, THREE_DOTS);
    }

    public static String truncateWithEllipsis(String s, int numberOfChars) {
        return StringUtils.truncate(s, numberOfChars, ELLIPSIS);
    }

    public static int editDistance(String s, String t) {
        char[] sChars = s.toCharArray();
        char[] tChars = t.toCharArray();
        int m = s.length();
        int n = t.length();
        int[] distance = new int[m + 1];
        for (int i = 0; i <= m; ++i) {
            distance[i] = i;
        }
        int[] oldDistance = new int[m + 1];
        for (int j = 1; j <= n; ++j) {
            int[] tmp = oldDistance;
            oldDistance = distance;
            distance = tmp;
            distance[0] = j;
            for (int i = 1; i <= m; ++i) {
                int cost = 1 + Math.min(distance[i - 1], oldDistance[i]);
                cost = sChars[i - 1] == tChars[j - 1] ? Math.min(cost, oldDistance[i - 1]) : Math.min(cost, 1 + oldDistance[i - 1]);
                distance[i] = cost;
            }
        }
        return distance[m];
    }

    public static boolean isEditDistanceAtMost1(String s, String t) {
        int tEnd;
        int tStart;
        int m = s.length();
        int n = t.length();
        if (Math.abs(n - m) > 1) {
            return false;
        }
        int sStart = 0;
        for (tStart = 0; sStart < m && tStart < n && s.charAt(sStart) == t.charAt(tStart); ++sStart, ++tStart) {
        }
        int sEnd = m - 1;
        for (tEnd = n - 1; sEnd >= sStart && tEnd >= tStart && s.charAt(sEnd) == t.charAt(tEnd); --sEnd, --tEnd) {
        }
        return sEnd <= sStart && tEnd <= tStart;
    }

    public static List<String> lowercaseList(Collection<String> strings) {
        ArrayList<String> lowercaseList = new ArrayList<String>();
        for (String string : strings) {
            lowercaseList.add(string.toLowerCase());
        }
        return lowercaseList;
    }

    public static String defaultIfNull(String input, String defaultValue) {
        if (input == null) {
            return defaultValue;
        }
        return input;
    }

    public static String defaultIfNullOrEmpty(@Nullable String input, String defaultValue) {
        if (StringUtils.isEmpty(input)) {
            return defaultValue;
        }
        return input;
    }

    public static String emptyIfNull(@Nullable String input) {
        return StringUtils.defaultIfNull(input, EMPTY_STRING);
    }

    public static List<String> splitTopLevel(String input, char separator, char levelStart, char levelEnd) {
        int currentLevel = 0;
        int currentStartIndex = 0;
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < input.length(); ++i) {
            char currentChar = input.charAt(i);
            if (currentChar == separator && currentLevel == 0) {
                result.add(input.substring(currentStartIndex, i));
                currentStartIndex = separator == levelStart ? i : i + 1;
            }
            if (currentChar == levelEnd && currentLevel > 0) {
                --currentLevel;
                continue;
            }
            if (currentChar != levelStart) continue;
            ++currentLevel;
        }
        CCSMAssert.isTrue(currentLevel == 0, "String is imbalanced: " + input);
        result.add(input.substring(currentStartIndex));
        return result;
    }

    public static String ensureEndsWith(String s, String suffix) {
        if (!s.endsWith(suffix)) {
            return s + suffix;
        }
        return s;
    }

    public static String ensureStartsWith(String s, String prefix) {
        if (!s.startsWith(prefix)) {
            return prefix + s;
        }
        return s;
    }

    public static String concatWithEscapeCharacter(List<String> data, String delimiter) {
        return data.stream().map(a -> a.replace(delimiter, "\\" + delimiter)).reduce((a, b) -> a + delimiter + b).orElse(EMPTY_STRING);
    }

    public static List<String> splitWithEscapeCharacter(String data, String delimiter) {
        if (StringUtils.isEmpty(data) || StringUtils.isEmpty(delimiter)) {
            return Collections.emptyList();
        }
        String regex = "(?<!\\\\)" + delimiter + "\\s*";
        return CollectionUtils.map(Arrays.asList(data.split(regex)), part -> part.trim().replace("\\" + delimiter, delimiter));
    }

    public static List<String> splitToList(String data, String separator) {
        if (StringUtils.isEmpty(data) || StringUtils.isEmpty(separator)) {
            return Collections.emptyList();
        }
        return CollectionUtils.map(Arrays.asList(data.split(separator)), String::trim);
    }

    public static String applyAllReplacements(String s, PairList<Pattern, String> replacements) {
        for (int i = 0; i < replacements.size(); ++i) {
            s = StringUtils.applyReplacement(s, replacements.getFirst(i), replacements.getSecond(i));
        }
        return s;
    }

    public static String applyReplacement(String s, Pattern pattern, String replacement) {
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            matcher.appendReplacement(buffer, replacement);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static String nullIfEmpty(String input) {
        if (StringUtils.isEmpty(input)) {
            return null;
        }
        return input;
    }

    public static boolean isInteger(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        if (string.startsWith("-") && string.length() > 1) {
            string = string.substring(1);
        }
        for (char c : string.toCharArray()) {
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static int indexOfMatch(String string, Pattern pattern) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!pattern.matcher(String.valueOf(c)).matches()) continue;
            return i;
        }
        return -1;
    }

    public static String escapeChars(String content, Map<CharSequence, CharSequence> escapeMap) {
        escapeMap = StringUtils.addEscapingForAlreadyEscapedNonSpecialChars(escapeMap);
        LookupTranslator translator = new LookupTranslator(escapeMap);
        return StringEscapeUtils.builder((CharSequenceTranslator)translator).escape(content).toString();
    }

    public static String unescapeChars(String content, Map<CharSequence, CharSequence> escapeMap) {
        escapeMap = StringUtils.addEscapingForAlreadyEscapedNonSpecialChars(escapeMap);
        LookupTranslator translator = new LookupTranslator(EntityArrays.invert(escapeMap));
        return StringEscapeUtils.builder((CharSequenceTranslator)translator).escape(content).toString();
    }

    private static Map<CharSequence, CharSequence> addEscapingForAlreadyEscapedNonSpecialChars(Map<CharSequence, CharSequence> escapeMap) {
        if (!escapeMap.containsKey("\\")) {
            return escapeMap;
        }
        HashMap<CharSequence, CharSequence> extendedEscapeMap = new HashMap<CharSequence, CharSequence>();
        for (Map.Entry<CharSequence, CharSequence> escapePair : escapeMap.entrySet()) {
            if (escapePair.getKey().equals("\\") || EntityArrays.JAVA_CTRL_CHARS_ESCAPE.containsKey(escapePair.getKey()) || !escapePair.getValue().equals("\\" + escapePair.getKey())) continue;
            extendedEscapeMap.put("\\" + escapePair.getKey(), "\\" + escapePair.getValue());
        }
        extendedEscapeMap.putAll(escapeMap);
        return extendedEscapeMap;
    }

    public static String escapeMarkdownChars(String content) {
        return StringUtils.escapeChars(content, MARKDOWN_ESCAPE_MAP);
    }

    public static String unescapeMarkdownChars(String content) {
        return StringUtils.unescapeChars(content, MARKDOWN_ESCAPE_MAP);
    }

    public static String getFirstCharacters(String s, int numberOfChars) {
        if (s.length() <= numberOfChars) {
            return s;
        }
        return s.substring(0, numberOfChars);
    }

    public static String getLastCharacters(String s, int numberOfChars) {
        if (s.length() <= numberOfChars) {
            return s;
        }
        return s.substring(s.length() - numberOfChars);
    }

    public static String toFirstUpper(String s) {
        if (StringUtils.isEmpty(s)) {
            return s;
        }
        char first = s.charAt(0);
        return Character.toUpperCase(first) + s.substring(1).toLowerCase();
    }

    public static String pluralize(String string, int count) {
        if (count == 1) {
            return string;
        }
        return string + "s";
    }

    public static String surroundWith(String s, String prefix, String suffix) {
        return prefix + s + suffix;
    }

    public static boolean equalsOneOf(String value, String ... strings) {
        for (String compareValue : strings) {
            if (!value.equals(compareValue)) continue;
            return true;
        }
        return false;
    }

    public static String removeDoubleQuotes(String string) {
        return StringUtils.stripPrefix(StringUtils.stripSuffix(string, "\""), "\"");
    }

    public static String removeSingleQuotes(String string) {
        return StringUtils.stripPrefix(StringUtils.stripSuffix(string, "'"), "'");
    }

    public static String repeat(String s, int times) {
        return new String(new char[times]).replace("\u0000", s);
    }

    public static @NonNull String safeToString(@Nullable Object value) {
        if (value == null) {
            return EMPTY_STRING;
        }
        return value.toString();
    }

    public static String retainHeadLines(String text, int numberOfLines) {
        if (text.isEmpty() || numberOfLines <= 1) {
            return EMPTY_STRING;
        }
        if (!text.contains(LINE_FEED)) {
            return text + LINE_FEED;
        }
        int charsBeforeCutLine = 0;
        for (int i = 0; i < numberOfLines; ++i) {
            if (charsBeforeCutLine >= text.length()) {
                return text;
            }
            charsBeforeCutLine = text.indexOf(LINE_FEED, charsBeforeCutLine) + 1;
        }
        return text.substring(0, charsBeforeCutLine - 1) + LINE_FEED;
    }

    static {
        HashMap<String, String> initialMap = new HashMap<String, String>();
        initialMap.put(LINE_FEED, "\\n");
        initialMap.put("\\n", "\\\\n");
        initialMap.put("\r", "\\r");
        initialMap.put("\\r", "\\\\r");
        initialMap.put("\r\n", "\\r\\n");
        initialMap.put("\\r\\n", "\\\\r\\\\n");
        ESCAPE_NEWLINE = Collections.unmodifiableMap(initialMap);
    }
}

