/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.treemap;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.conqat.lib.commons.color.MultiColor;
import org.conqat.lib.commons.treemap.IDrawingPattern;
import org.conqat.lib.commons.treemap.ITreeMapNode;
import org.conqat.lib.commons.treemap.ITreeMapRenderer;

public class CushionTreeMapRenderer
implements ITreeMapRenderer {
    private final double h;
    private final double f;

    public CushionTreeMapRenderer(double h, double f) {
        this.h = h;
        this.f = f;
    }

    @Override
    public <T> void renderTreeMap(ITreeMapNode<T> node, Graphics2D graphics) {
        for (ITreeMapNode<T> child : node.getChildren()) {
            this.render(child, graphics, this.h, new double[4]);
        }
    }

    private <T> void render(ITreeMapNode<T> node, Graphics2D g, double height, double[] coefs) {
        Rectangle2D rect = node.getLayoutRectangle();
        if (rect == null) {
            return;
        }
        double[] myCoefs = CushionTreeMapRenderer.addLocalParabola(height, coefs, rect);
        if (node.getChildren().isEmpty()) {
            CushionTreeMapRenderer.renderCushion(rect, myCoefs, g, node.getColor(), node.getPatternColor(), node.getDrawingPattern());
        } else if (node.getChildren().size() == 1) {
            this.render(node.getChildren().get(0), g, height, coefs);
        } else {
            for (ITreeMapNode<T> child : node.getChildren()) {
                this.render(child, g, height * this.f, myCoefs);
            }
        }
    }

    private static double[] addLocalParabola(double height, double[] coefs, Rectangle2D rect) {
        double[] myCoefs = new double[4];
        double x1 = rect.getMinX();
        double x2 = rect.getMaxX();
        double y1 = rect.getMinY();
        double y2 = rect.getMaxY();
        myCoefs[0] = coefs[0] - 4.0 * height / (x2 - x1);
        myCoefs[1] = coefs[1] + 4.0 * height * (x1 + x2) / (x2 - x1);
        myCoefs[2] = coefs[2] - 4.0 * height / (y2 - y1);
        myCoefs[3] = coefs[3] + 4.0 * height * (y1 + y2) / (y2 - y1);
        return myCoefs;
    }

    private static void renderCushion(Rectangle2D rect, double[] coefs, Graphics2D g, Color baseColor, Color patternColor, IDrawingPattern drawingPattern) {
        double lx = 0.09759;
        double ly = 0.19518;
        double lz = 0.9759;
        int minX = (int)(rect.getMinX() + 0.5);
        int minY = (int)(rect.getMinY() + 0.5);
        int maxX = (int)(rect.getMaxX() + 0.5);
        int maxY = (int)(rect.getMaxY() + 0.5);
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                double nx = -(2.0 * coefs[0] * ((double)x + 0.5) + coefs[1]);
                double ny = -(2.0 * coefs[2] * ((double)y + 0.5) + coefs[3]);
                double norm = Math.sqrt(nx * nx + ny * ny + 1.0);
                double cosa = (nx * 0.09759 + ny * 0.19518 + 0.9759) / norm;
                Color color = CushionTreeMapRenderer.determineBaseColor(x, y, baseColor, patternColor, drawingPattern, rect);
                g.setColor(CushionTreeMapRenderer.shadeColor(color, 0.2 + 0.8 * Math.max(0.0, cosa)));
                g.drawLine(x, y, x, y);
            }
        }
    }

    private static Color determineBaseColor(int x, int y, Color baseColor, Color patternColor, IDrawingPattern drawingPattern, Rectangle2D rect) {
        if (drawingPattern != null && drawingPattern.isForeground(x, y)) {
            return CushionTreeMapRenderer.resolveMultiColor(x, y, rect, patternColor);
        }
        return CushionTreeMapRenderer.resolveMultiColor(x, y, rect, baseColor);
    }

    private static Color resolveMultiColor(int x, int y, Rectangle2D rect, Color color) {
        if (!(color instanceof MultiColor)) {
            return color;
        }
        MultiColor multiColor = (MultiColor)color;
        double relative = rect.getWidth() > rect.getHeight() ? ((double)x - rect.getX()) / rect.getWidth() : ((double)y - rect.getY()) / rect.getHeight();
        double current = 0.0;
        for (int i = 0; i < multiColor.size(); ++i) {
            if (!((current += multiColor.getRelativeFrequency(i)) > relative)) continue;
            return multiColor.getColor(i);
        }
        return multiColor.getColor(multiColor.size() - 1);
    }

    private static Color shadeColor(Color color, double luminance) {
        int base = 0;
        if ((luminance *= 2.0) > 1.0) {
            luminance = 2.0 - luminance;
            base = (int)(255.0 * (1.0 - luminance));
        }
        return new Color((int)((double)color.getRed() * luminance) + base, (int)((double)color.getGreen() * luminance) + base, (int)((double)color.getBlue() * luminance) + base);
    }
}

