/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.treemap;

import java.awt.geom.Rectangle2D;
import org.conqat.lib.commons.treemap.ITreeMapLayoutAlgorithm;
import org.conqat.lib.commons.treemap.ITreeMapNode;
import org.conqat.lib.commons.treemap.SquarifiedTreeMapAlgorithm;
import org.conqat.lib.commons.treemap.StripeTreeMapAlgorithm;

public class MixedTreeMapAlgorithm
implements ITreeMapLayoutAlgorithm {
    @Override
    public <T> void layout(ITreeMapNode<T> rootNode, Rectangle2D targetArea) {
        new StripeTreeMapAlgorithm().layout(rootNode, targetArea);
        MixedTreeMapAlgorithm.performLocalSquareLayout(rootNode);
    }

    private static <T> int performLocalSquareLayout(ITreeMapNode<T> node) {
        if (node.getChildren().isEmpty()) {
            return 0;
        }
        int distance = 0;
        for (ITreeMapNode<T> child : node.getChildren()) {
            distance = Math.max(distance, MixedTreeMapAlgorithm.performLocalSquareLayout(child) + 1);
        }
        if (distance == 3) {
            new SquarifiedTreeMapAlgorithm().layout(node, node.getLayoutRectangle());
        }
        return distance;
    }
}

