/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.treemap;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.treemap.ITreeMapLayoutAlgorithm;
import org.conqat.lib.commons.treemap.ITreeMapNode;

public class SquarifiedTreeMapAlgorithm
implements ITreeMapLayoutAlgorithm {
    @Override
    public <T> void layout(ITreeMapNode<T> rootNode, Rectangle2D targetArea) {
        rootNode.setLayoutRectangle(targetArea);
        this.layoutChildren(rootNode);
    }

    private <T> void layoutChildren(ITreeMapNode<T> node) {
        if (node.getChildren().isEmpty()) {
            return;
        }
        Rectangle2D rect = node.getLayoutRectangle();
        double areaScale = rect.getWidth() * rect.getHeight() / node.getArea();
        ArrayList<ITreeMapNode<T>> sortedNodes = new ArrayList<ITreeMapNode<T>>(node.getChildren());
        Collections.sort(sortedNodes, new Comparator<ITreeMapNode<T>>(){

            @Override
            public int compare(ITreeMapNode<T> node1, ITreeMapNode<T> node2) {
                return Double.compare(node2.getArea(), node1.getArea());
            }
        });
        while (!sortedNodes.isEmpty() && CollectionUtils.getLast(sortedNodes).getArea() <= 0.0) {
            sortedNodes.remove(sortedNodes.size() - 1);
        }
        int start = 0;
        double shorterSide = Math.min(rect.getWidth(), rect.getHeight());
        int end = 1;
        while (end <= sortedNodes.size()) {
            if (end < sortedNodes.size() && SquarifiedTreeMapAlgorithm.worstAspectRatio(sortedNodes.subList(start, end), shorterSide, areaScale) > SquarifiedTreeMapAlgorithm.worstAspectRatio(sortedNodes.subList(start, end + 1), shorterSide, areaScale)) {
                ++end;
                continue;
            }
            rect = SquarifiedTreeMapAlgorithm.layoutRow(sortedNodes.subList(start, end), rect, areaScale);
            shorterSide = Math.min(rect.getWidth(), rect.getHeight());
            start = end;
            end = start + 1;
        }
        for (ITreeMapNode iTreeMapNode : sortedNodes) {
            this.layoutChildren(iTreeMapNode);
        }
    }

    private static <T> Rectangle2D layoutRow(List<ITreeMapNode<T>> nodes, Rectangle2D rect, double areaScale) {
        double overallArea = SquarifiedTreeMapAlgorithm.getArea(nodes);
        if (rect.getWidth() < rect.getHeight()) {
            double height = overallArea * areaScale / rect.getWidth();
            double x = rect.getX();
            for (ITreeMapNode<T> node : nodes) {
                double nodeWidth = node.getArea() * areaScale / height;
                node.setLayoutRectangle(new Rectangle2D.Double(x, rect.getY(), nodeWidth, height));
                x += nodeWidth;
            }
            return new Rectangle2D.Double(rect.getX(), rect.getY() + height, rect.getWidth(), rect.getHeight() - height);
        }
        double width = overallArea * areaScale / rect.getHeight();
        double y = rect.getY();
        for (ITreeMapNode<T> node : nodes) {
            double nodeHeight = node.getArea() * areaScale / width;
            node.setLayoutRectangle(new Rectangle2D.Double(rect.getX(), y, width, nodeHeight));
            y += nodeHeight;
        }
        return new Rectangle2D.Double(rect.getX() + width, rect.getY(), rect.getWidth() - width, rect.getHeight());
    }

    private static <T> double worstAspectRatio(List<ITreeMapNode<T>> nodes, double minSide, double areaScale) {
        double overallArea = SquarifiedTreeMapAlgorithm.getArea(nodes) * areaScale;
        double side = overallArea / minSide;
        double worst = 1.0;
        for (ITreeMapNode<T> node : nodes) {
            double aspect = node.getArea() * areaScale / side / side;
            worst = Math.max(worst, Math.max(aspect, 1.0 / aspect));
        }
        return worst;
    }

    private static <T> double getArea(List<ITreeMapNode<T>> nodes) {
        double area = 0.0;
        for (ITreeMapNode<T> node : nodes) {
            area += node.getArea();
        }
        return area;
    }
}

