/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.xml;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.enums.EnumUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ElementEnumSaxHandler<ELEMENT extends Enum<ELEMENT>>
extends DefaultHandler {
    private ELEMENT element;
    private boolean hasReachedStartElement = false;
    private final Map<ELEMENT, ElementHandler<ELEMENT>> handlers = new HashMap<ELEMENT, ElementHandler<ELEMENT>>();
    private final Deque<ELEMENT> openedElements = new ArrayDeque<ELEMENT>();
    private final Deque<StringBuffer> textBuffers = new ArrayDeque<StringBuffer>();
    private IElementResolver resolver = new JavaConstantResolver();

    public ElementEnumSaxHandler(ELEMENT initialElement) {
        this.element = initialElement;
    }

    public void setElementHandler(ELEMENT element, ElementHandler<ELEMENT> handler) {
        this.handlers.put(element, handler);
    }

    public void setElementResolver(IElementResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        ELEMENT nextElement = this.getEnumForElement(localName);
        if (nextElement == null) {
            return;
        }
        if (!this.hasReachedStartElement) {
            if (this.element != nextElement) {
                return;
            }
            this.hasReachedStartElement = true;
        } else if (!((IElementEnum)this.element).nextElements().contains(nextElement)) {
            return;
        }
        this.element = nextElement;
        this.openedElements.push(this.element);
        ElementHandler<ELEMENT> handler = this.handlers.get(this.element);
        if (this.handlers.containsKey(this.element)) {
            handler.onStartElement(this.element, attributes);
            if (handler instanceof TextElementHandler) {
                this.textBuffers.push(new StringBuffer());
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        StringBuffer buffer = this.textBuffers.peek();
        if (buffer != null) {
            buffer.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        ELEMENT endedElement = this.getEnumForElement(localName);
        if (endedElement == null || endedElement != this.openedElements.peek()) {
            return;
        }
        this.openedElements.pop();
        ElementHandler<ELEMENT> handler = this.handlers.get(endedElement);
        if (handler == null) {
            return;
        }
        if (handler instanceof TextElementHandler) {
            TextElementHandler textHandler = (TextElementHandler)handler;
            StringBuffer buffer = this.textBuffers.pop();
            textHandler.onText(endedElement, buffer.toString());
        }
        handler.onEndElement(endedElement);
    }

    private ELEMENT getEnumForElement(String elementName) throws AssertionError {
        if (this.resolver != null) {
            elementName = this.resolver.resolve(elementName);
        }
        Class<?> enumClass = null;
        enumClass = this.element.getClass().isEnum() ? this.element.getClass() : this.element.getClass().getSuperclass();
        return (ELEMENT)EnumUtils.valueOf(enumClass, elementName);
    }

    public static class JavaConstantResolver
    implements IElementResolver {
        @Override
        public String resolve(String elementName) {
            return elementName.toUpperCase().replaceAll("\\W+", "_");
        }
    }

    public static interface IElementResolver {
        public String resolve(String var1);
    }

    public static class TextElementHandler<ELEMENT>
    extends ElementHandler<ELEMENT> {
        public void onText(ELEMENT element, String text) throws SAXException {
        }
    }

    public static class ElementHandler<ELEMENT> {
        public void onStartElement(ELEMENT element, Attributes attributes) throws SAXException {
        }

        public void onEndElement(ELEMENT element) throws SAXException {
        }
    }

    public static interface IElementEnum<E extends Enum<E>> {
        public Set<E> nextElements();
    }
}

