/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.IXMLElementProcessor;
import org.conqat.lib.commons.xml.IXMLResolver;
import org.conqat.lib.commons.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XMLReader<E extends Enum<E>, A extends Enum<A>, X extends Exception> {
    private Element currentDOMElement;
    private URL schemaURL;
    private final IXMLResolver<E, A> xmlResolver;
    private final Reader reader;

    public XMLReader(File file, IXMLResolver<E, A> xmlResolver) throws IOException {
        this(file, null, xmlResolver);
    }

    public XMLReader(File file, Charset encoding, IXMLResolver<E, A> xmlResolver) throws IOException {
        this(FileSystemUtils.streamReader(new FileInputStream(file), XMLReader.ensureNotNullEncoding(encoding)), xmlResolver);
    }

    public XMLReader(String content, IXMLResolver<E, A> xmlResolver) {
        this(new StringReader(content), xmlResolver);
    }

    public XMLReader(Reader reader, IXMLResolver<E, A> xmlResolver) {
        CCSMAssert.isFalse(reader == null, "Reader may not be null.");
        CCSMAssert.isFalse(xmlResolver == null, "XML resolver may not be null.");
        this.reader = reader;
        this.xmlResolver = xmlResolver;
    }

    private static Charset ensureNotNullEncoding(Charset encoding) {
        if (encoding == null) {
            return Charset.defaultCharset();
        }
        return encoding;
    }

    protected void setSchema(URL schemaURL) {
        this.schemaURL = schemaURL;
    }

    protected boolean getBooleanAttribute(A attribute) {
        String value = this.getStringAttribute(attribute);
        return Boolean.parseBoolean(value);
    }

    protected String getChildText(E childElement) {
        String elementName = this.xmlResolver.resolveElementName(childElement);
        Element domElement = XMLUtils.getNamedChild(this.currentDOMElement, elementName);
        if (domElement == null) {
            return null;
        }
        return domElement.getTextContent();
    }

    protected <T extends Enum<T>> T getEnumAttribute(A attribute, Class<T> enumClass) {
        String value = this.getStringAttribute(attribute);
        return Enum.valueOf(enumClass, value);
    }

    protected <T extends Enum<T>> T getEnumAttributeIgnoreCase(A attribute, Class<T> enumClass, T defaultValue) {
        String value = this.getStringAttribute(attribute);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        T result = EnumUtils.valueOfIgnoreCase(enumClass, value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    protected int getIntAttribute(A attribute) {
        String value = this.getStringAttribute(attribute);
        return Integer.parseInt(value);
    }

    protected long getLongAttribute(A attribute) {
        String value = this.getStringAttribute(attribute);
        return Long.parseLong(value);
    }

    protected String getStringAttribute(A attribute) {
        return this.currentDOMElement.getAttribute(this.xmlResolver.resolveAttributeName(attribute));
    }

    protected String getNonEmptyStringAttribute(A attribute) throws IOException {
        String value = this.getStringAttribute(attribute);
        if (StringUtils.isEmpty(value)) {
            throw new IOException("Expected non-empty value for " + ((Enum)attribute).name());
        }
        return value;
    }

    protected boolean hasAttribute(A attribute) {
        return this.currentDOMElement.hasAttribute(this.xmlResolver.resolveAttributeName(attribute));
    }

    protected String getText() {
        return this.currentDOMElement.getTextContent();
    }

    protected void parseFile() throws SAXException, IOException {
        try {
            InputSource input = new InputSource(this.reader);
            Document document = this.schemaURL == null ? XMLUtils.parse(input) : XMLUtils.parse(input, this.schemaURL);
            this.currentDOMElement = document.getDocumentElement();
        }
        finally {
            this.reader.close();
        }
    }

    protected void processChildElements(IXMLElementProcessor<E, X> processor) throws X {
        String targetElementName = this.xmlResolver.resolveElementName(processor.getTargetElement());
        this.processElementList(processor, XMLUtils.getNamedChildren(this.currentDOMElement, targetElementName));
    }

    protected void processDecendantElements(IXMLElementProcessor<E, X> processor) throws X {
        String targetElementName = this.xmlResolver.resolveElementName(processor.getTargetElement());
        NodeList descendantNodes = this.currentDOMElement.getElementsByTagName(targetElementName);
        this.processElementList(processor, XMLUtils.elementNodes(descendantNodes));
    }

    private void processElementList(IXMLElementProcessor<E, X> processor, List<Element> elements) throws X {
        Element oldElement = this.currentDOMElement;
        Iterator<Element> iterator = elements.iterator();
        while (iterator.hasNext()) {
            Element child;
            this.currentDOMElement = child = iterator.next();
            processor.process();
        }
        this.currentDOMElement = oldElement;
    }

    protected void apply(IXMLElementProcessor<E, X> ... processors) throws X {
        HashMap<String, IXMLElementProcessor<E, X>> processorMap = new HashMap<String, IXMLElementProcessor<E, X>>();
        for (IXMLElementProcessor<E, X> processor : processors) {
            String targetElementName = this.xmlResolver.resolveElementName(processor.getTargetElement());
            CCSMAssert.isFalse(processorMap.containsKey(targetElementName), "Multiple processors found for element: " + targetElementName);
            processorMap.put(targetElementName, processor);
        }
        Element oldElement = this.currentDOMElement;
        this.traverse(processorMap);
        this.currentDOMElement = oldElement;
    }

    private void traverse(Map<String, IXMLElementProcessor<E, X>> processorMap) throws X {
        IXMLElementProcessor<E, X> processor = processorMap.get(this.currentDOMElement.getTagName());
        if (processor != null) {
            processor.process();
        }
        NodeList nodeList = this.currentDOMElement.getChildNodes();
        Iterator<Element> iterator = XMLUtils.elementNodes(nodeList).iterator();
        while (iterator.hasNext()) {
            Element element;
            this.currentDOMElement = element = iterator.next();
            this.traverse(processorMap);
        }
    }
}

