/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.assertion;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.Contract;

public class CCSMAssert {
    @Contract(value="false, _ -> fail", pure=true)
    public static void isTrue(boolean condition, String message) throws AssertionError {
        CCSMAssert.throwAssertionErrorIfTestFails(condition, message);
    }

    @Contract(value="false, _ -> fail", pure=true)
    public static void isTrue(boolean condition, Supplier<String> messageSupplier) throws AssertionError {
        CCSMAssert.throwAssertionErrorIfTestFails(condition, messageSupplier);
    }

    @Contract(value="true, _ -> fail", pure=true)
    public static void isFalse(boolean condition, String message) throws AssertionError {
        CCSMAssert.throwAssertionErrorIfTestFails(!condition, message);
    }

    @Contract(value="true, _ -> fail", pure=true)
    public static void isFalse(boolean condition, Supplier<String> messageSupplier) throws AssertionError {
        CCSMAssert.throwAssertionErrorIfTestFails(!condition, messageSupplier);
    }

    public static void isInstanceOf(Object object, Class<?> clazz) {
        CCSMAssert.isNotNull(clazz, () -> "Object " + object + " can't be an instance of class null.");
        CCSMAssert.isTrue(clazz.isInstance(object), () -> {
            String message = object + "";
            if (object != null) {
                message = message + " of type " + object.getClass().getName();
            }
            return message + " must be an instance of " + clazz.getName();
        });
    }

    public static <T> T checkedCast(Object object, Class<T> clazz) {
        CCSMAssert.isInstanceOf(object, clazz);
        return (T)object;
    }

    @Contract(value="_, _ -> fail", pure=true)
    public static void fail(String message, Throwable t) throws AssertionError {
        throw new AssertionError(message, t);
    }

    @Contract(value="_ -> fail", pure=true)
    public static void fail(String message) throws AssertionError {
        throw new AssertionError((Object)message);
    }

    @Contract(value="null -> fail", pure=true)
    public static void isNotNull(Object reference) throws AssertionError {
        CCSMAssert.isNotNull(reference, "Reference must not be null");
    }

    @Contract(value="null, _ -> fail", pure=true)
    public static void isNotNull(Object reference, String message) throws AssertionError {
        CCSMAssert.throwAssertionErrorIfTestFails(reference != null, message);
    }

    @Contract(value="null, _ -> fail", pure=true)
    public static void isNotNull(Object reference, Supplier<String> messageSupplier) throws AssertionError {
        CCSMAssert.throwAssertionErrorIfTestFails(reference != null, messageSupplier);
    }

    @Contract(value="null, _ -> fail", pure=true)
    public static void isNotEmpty(String s, String message) throws AssertionError {
        CCSMAssert.throwAssertionErrorIfTestFails(!StringUtils.isEmpty(s), message);
    }

    @Contract(value="null, _ -> fail", pure=true)
    public static void isNotEmpty(String s, Supplier<String> messageSupplier) throws AssertionError {
        CCSMAssert.throwAssertionErrorIfTestFails(!StringUtils.isEmpty(s), messageSupplier);
    }

    @Contract(value="null, _ -> fail", pure=true)
    public static void isNotEmpty(Collection<?> collection, String message) throws AssertionError {
        CCSMAssert.throwAssertionErrorIfTestFails(!CollectionUtils.isNullOrEmpty(collection), message);
    }

    @Contract(value="null, _ -> fail", pure=true)
    public static void isNotEmpty(Collection<?> collection, Supplier<String> messageSupplier) throws AssertionError {
        CCSMAssert.throwAssertionErrorIfTestFails(!CollectionUtils.isNullOrEmpty(collection), messageSupplier);
    }

    public static void isPresent(Optional<?> optional, String message) {
        CCSMAssert.throwAssertionErrorIfTestFails(optional.isPresent(), message);
    }

    public static void isPresent(Optional<?> optional, Supplier<String> messageSupplier) {
        CCSMAssert.throwAssertionErrorIfTestFails(optional.isPresent(), messageSupplier);
    }

    public static void isEmpty(Optional<?> optional, String message) {
        CCSMAssert.throwAssertionErrorIfTestFails(!optional.isPresent(), message);
    }

    private static void throwAssertionErrorIfTestFails(boolean test, Supplier<String> messageSupplier) {
        if (!test) {
            throw new AssertionError((Object)messageSupplier.get());
        }
    }

    private static void throwAssertionErrorIfTestFails(boolean test, String message) {
        if (!test) {
            throw new AssertionError((Object)message);
        }
    }
}

