/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.assessment;

import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

@ExportToTypeScript
public enum ETrafficLightColor {
    RED("#FF3333"),
    ORANGE("#FF9966"),
    YELLOW("#FBBC05"),
    GREEN("#00CC33"),
    BASELINE("#DFEAF4"),
    UNKNOWN;

    private final String displayText = this.name().substring(0, 1) + this.name().substring(1).toLowerCase();
    private final String shortDisplayText = this.name().substring(0, 1);
    private final String hexValue;
    private static final String HEX_VALUE_BLACK = "#000000";

    private ETrafficLightColor() {
        this(HEX_VALUE_BLACK);
    }

    private ETrafficLightColor(String hexValue) {
        this.hexValue = hexValue;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public String getShortDisplayText() {
        return this.shortDisplayText;
    }

    public String getHexValue() {
        return this.hexValue;
    }

    public static ETrafficLightColor getDominantColor(ETrafficLightColor color1, ETrafficLightColor color2) {
        if (color2.ordinal() < color1.ordinal()) {
            return color2;
        }
        return color1;
    }

    public static List<ETrafficLightColor> getTrafficLightColors() {
        ArrayList<ETrafficLightColor> trafficLights = new ArrayList<ETrafficLightColor>();
        trafficLights.add(RED);
        trafficLights.add(YELLOW);
        trafficLights.add(GREEN);
        return trafficLights;
    }
}

